% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spidR.R
\name{traits}
\alias{traits}
\title{Get trait data from WST.}
\usage{
traits(
  tax,
  trait = NULL,
  sex = NULL,
  life = NULL,
  country = NULL,
  habitat = NULL,
  order = FALSE,
  user = "",
  key = ""
)
}
\arguments{
\item{tax}{A taxon name or vector with taxa names.}

\item{trait}{A vector with required trait(s) as abbreviations. Valid values can be found at: https://spidertraits.sci.muni.cz/traits}

\item{sex}{A vector with required sex(es).}

\item{life}{A vector with required life stage(s).}

\item{country}{A vector with required country(ies) ISO3 code(s).}

\item{habitat}{A vector with required habitat(s).}

\item{order}{Order taxa names alphabetically or keep as in tax.}

\item{user}{To obtain restricted data get a user name from https://spidertraits.sci.muni.cz/api.}

\item{key}{To obtain restricted data get an api key from https://spidertraits.sci.muni.cz/api.}
}
\value{
A matrix with trait data.
}
\description{
Downloads the most recent data from the World Spider Trait database.
}
\details{
The World Spider Trait database (Pekar et al. 2021) has been designed to contain trait data in a broad sense, from morphological traits to ecological characteristics, ecophysiology, behavioural habits, and more (Lowe et al. 2020). This function will download everything available for the taxa given, possibly filtered to the traits given in parameter trait. Some data might be restricted access, in which case a user name and api key are needed (https://spidertraits.sci.muni.cz/api), otherwise the value will show as NA.
}
\examples{
\dontrun{
traits("Atypus affinis")
traits("Atypus", order = TRUE)
traits("Atypidae", country = c("PRT", "CZE"), order = TRUE)
traits(c("Zodarion costapratae", "Zodarion alacre"))
traits(c("Iberesia machadoi", "Zodarion costapratae"), trait = c("balo", "bole"))
}
}
\references{
Lowe, E., Wolff, J.O., Aceves-Aparicio, A., Birkhofer, K., Branco, V.V., Cardoso, P., Chichorro, F., Fukushima, C.S., Goncalves-Souza, T., Haddad, C.R., Isaia, M., Krehenwinkel, H., Audisio, T.L., Macias-Hernandez, N., Malumbres-Olarte, J., Mammola, S., McLean, D.J., Michalko, R., Nentwig, W., Pekar, S., Petillon, J., Privet, K., Scott, C., Uhl, G., Urbano-Tenorio, F., Wong, B.H. & Herbestein, M.E. (2020). Towards establishment of a centralized spider traits database. Journal of Arachnology, 48: 103-109. https://doi.org/10.1636/0161-8202-48.2.103

Pekar, S., Cernecka, L., Wolff, J., Mammola, S., Cardoso, P., Lowe, E., Fukushima, C.S., Birkhofer, K. & Herberstein, M.E. (2021). The spider trait database. Masaryk University, Brno, URL: https://spidertraits.sci.muni.cz
}
