% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sperrorest_error.R
\name{err.default}
\alias{err.default}
\title{Default error function}
\usage{
err.default(obs, pred)
}
\arguments{
\item{obs}{factor, logical, or numeric vector with observations}

\item{pred}{factor, logical, or numeric vector with predictions. Must be of
same type as \code{obs} with the exception that \code{pred} may be numeric
if \code{obs} is \code{factor} or \code{logical} ('soft' classification).}
}
\value{
A list with (currently) the following components, depending on the
type of prediction problem:

\item{'hard' classification}{misclassification error, overall accuracy;
if two classes, sensitivity, specificity, positive predictive value (PPV),
negative predictive value (NPV), kappa}
\item{'soft' classification}{area under the ROC curve, error and accuracy
at a obs>0.5 dichotomization, false-positive rate (FPR; 1-specificity)
at 70, 80 and 90 percent sensitivity, true-positive rate (sensitivity)
at 80, 90 and 95 percent specificity}
\item{regression}{bias, standard deviation, mean squared error,
MAD (\code{\link[=mad]{mad()}}), median, interquartile range (\code{\link[=IQR]{IQR()}})
of residuals}
}
\description{
Calculate a variety of accuracy measures from observations and predictions
of numerical and categorical response variables.
}
\note{
\code{NA} values are currently not handled by this function,
i.e. they will result in an error.
}
\examples{
obs <- rnorm(1000)
# Two mock (soft) classification examples:
err.default( obs > 0, rnorm(1000) ) # just noise
err.default( obs > 0, obs + rnorm(1000) ) # some discrimination
# Three mock regression examples:
err.default( obs, rnorm(1000) ) # just noise, but no bias
err.default( obs, obs + rnorm(1000) ) # some association, no bias
err.default( obs, obs + 1 ) # perfect correlation, but with bias

}
\seealso{
\pkg{ROCR}
}
