/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern.color;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.common.ColorMap;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.common.intern.color.ColorTransmitter;
import bibliothek.gui.dock.themes.color.TitleColor;
import bibliothek.gui.dock.util.color.ColorManager;
import bibliothek.gui.dock.util.color.DockColor;
import java.awt.Color;

public abstract class TitleColorTransmitter
extends ColorTransmitter {
    private ColorManager manager;
    private String[] keys;

    public TitleColorTransmitter(ColorManager manager, String ... keys) {
        super(keys);
        this.keys = keys;
        this.manager = manager;
    }

    protected abstract Color convert(Color var1, String var2);

    protected abstract Color convertFocused(Color var1, String var2);

    protected abstract boolean isForeground(String var1);

    protected abstract boolean isFocused(String var1);

    public String[] getKeys() {
        return this.keys;
    }

    protected Color get(Color color, String id, DockColor observer) {
        CDockable dockable = this.getDockable(observer);
        if (dockable != null) {
            return this.get(color, id, dockable);
        }
        return color;
    }

    protected CDockable getDockable(DockColor observer) {
        Dockable dockable = ((TitleColor)observer).getTitle().getDockable();
        if (dockable instanceof CommonDockable) {
            return ((CommonDockable)dockable).getDockable();
        }
        return null;
    }

    protected Color get(Color color, String id, CDockable dockable) {
        Color check = null;
        ColorMap colors = dockable.getColors();
        boolean foreground = this.isForeground(id);
        boolean focused = this.isFocused(id);
        if (foreground) {
            if (focused) {
                check = colors.getColor("title.foreground.focused");
            }
            if (check == null) {
                check = colors.getColor("title.foreground");
            }
        }
        if (check == null) {
            if (focused && (check = colors.getColor("title.background.focused")) != null) {
                check = this.convertFocused(check, id);
            }
            if (check == null && (check = colors.getColor("title.background")) != null) {
                check = this.convert(check, id);
            }
        }
        if (check != null) {
            return check;
        }
        return color;
    }

    protected void update(CDockable dockable, String key, Color color) {
        boolean change;
        boolean bl = change = "title.background".equals(key) || "title.background.focused".equals(key) || "title.foreground".equals(key) || "title.foreground.focused".equals(key);
        if (change) {
            for (String check : this.keys) {
                this.set(check, this.get((Color)this.manager.get(check), check, dockable), dockable);
            }
        }
    }
}

