/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.screen;

import bibliothek.gui.DockController;
import bibliothek.gui.dock.station.screen.ScreenDockWindow;
import bibliothek.gui.dock.station.screen.ScreenDockWindowColor;
import bibliothek.gui.dock.util.color.AbstractDockColor;
import bibliothek.gui.dock.util.color.ColorManager;
import bibliothek.util.Colors;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.border.Border;

public class ScreenDockWindowBorder
implements Border {
    private int cornerSize = 0;
    private int moveSize = 0;
    private Position mouseOver = Position.NOTHING;
    private Position mousePressed = Position.NOTHING;
    private boolean drawDividers = true;
    private JComponent target;
    private ScreenDockWindow window;
    private DockController controller;
    protected final BorderColor colorLine = new BorderColor("line");
    protected final BorderColor colorLineHighlightInner = new BorderColor("line.highlight.inner");
    protected final BorderColor colorLineHighlightOuter = new BorderColor("line.highlight.outer");
    protected final BorderColor colorLineShadowInner = new BorderColor("line.shadow.inner");
    protected final BorderColor colorLineShadowOuter = new BorderColor("line.shadow.outer");
    protected final BorderColor color = new BorderColor();
    protected final BorderColor colorHighlightInner = new BorderColor("highlight.inner");
    protected final BorderColor colorHighlightOuter = new BorderColor("highlight.outer");
    protected final BorderColor colorShadowInner = new BorderColor("shadow.inner");
    protected final BorderColor colorShadowOuter = new BorderColor("shadow.outer");
    protected final BorderColor colorHover = new BorderColor("hover");
    protected final BorderColor colorHighlightInnerHover = new BorderColor("highlight.inner.hover");
    protected final BorderColor colorHighlightOuterHover = new BorderColor("highlight.outer.hover");
    protected final BorderColor colorShadowInnerHover = new BorderColor("shadow.inner.hover");
    protected final BorderColor colorShadowOuterHover = new BorderColor("shadow.outer.hover");
    protected final BorderColor colorSelected = new BorderColor("selected");
    protected final BorderColor colorHighlightInnerSelected = new BorderColor("highlight.inner.selected");
    protected final BorderColor colorHighlightOuterSelected = new BorderColor("highlight.outer.selected");
    protected final BorderColor colorShadowInnerSelected = new BorderColor("shadow.inner.selected");
    protected final BorderColor colorShadowOuterSelected = new BorderColor("shadow.outer.selected");
    private BorderColor[] colors;

    public ScreenDockWindowBorder(ScreenDockWindow window, JComponent target) {
        if (window == null) {
            throw new IllegalArgumentException("window must not be null");
        }
        if (target == null) {
            throw new IllegalArgumentException("target must not be null");
        }
        this.window = window;
        this.target = target;
        this.colors = new BorderColor[]{this.colorLine, this.colorLineHighlightInner, this.colorLineHighlightOuter, this.colorLineShadowInner, this.colorLineShadowOuter, this.color, this.colorHighlightInner, this.colorHighlightOuter, this.colorShadowInner, this.colorShadowOuter, this.colorHover, this.colorHighlightInnerHover, this.colorHighlightOuterHover, this.colorShadowInnerHover, this.colorShadowOuterHover, this.colorSelected, this.colorHighlightInnerSelected, this.colorHighlightOuterSelected, this.colorShadowInnerSelected, this.colorShadowOuterSelected};
    }

    public void setController(DockController controller) {
        this.controller = controller;
        ColorManager manager = controller == null ? null : controller.getColors();
        for (BorderColor color : this.colors) {
            color.setManager(manager);
        }
    }

    public DockController getController() {
        return this.controller;
    }

    public void setCornerSize(int cornerSize) {
        if (this.cornerSize != cornerSize) {
            this.cornerSize = cornerSize;
            this.target.repaint();
        }
    }

    public int getCornerSize() {
        return this.cornerSize;
    }

    public void setMoveSize(int moveSize) {
        if (this.moveSize != moveSize) {
            this.moveSize = moveSize;
            this.target.repaint();
        }
    }

    public int getMoveSize() {
        return this.moveSize;
    }

    public void setDrawDividers(boolean drawDividers) {
        if (this.drawDividers != drawDividers) {
            this.drawDividers = drawDividers;
            this.target.repaint();
        }
    }

    public boolean isDrawDividers() {
        return this.drawDividers;
    }

    public void setMouseOver(Position mouseOver) {
        if (mouseOver == null) {
            mouseOver = Position.NOTHING;
        }
        if (this.mouseOver != mouseOver) {
            this.mouseOver = mouseOver;
            this.target.repaint();
        }
    }

    public void setMousePressed(Position mousePressed) {
        if (mousePressed == null) {
            mousePressed = Position.NOTHING;
        }
        if (this.mousePressed != mousePressed) {
            this.mousePressed = mousePressed;
            this.target.repaint();
        }
    }

    public Insets getBorderInsets(Component c) {
        return new Insets(5, 4, 4, 4);
    }

    public boolean isBorderOpaque() {
        return true;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        g.translate(x, y);
        Insets insets = this.getBorderInsets(c);
        int hWidth = width / 2;
        int titleLeft = x + hWidth - this.moveSize / 2;
        int titleRight = x + hWidth + this.moveSize / 2;
        int corner = Math.max(this.cornerSize, Math.max(Math.max(insets.top, insets.bottom), Math.max(insets.left, insets.right)));
        if (this.moveSize > 0) {
            if (insets.top > 2) {
                g.setColor(this.getColor(c, Position.MOVE));
                g.fillRect(titleLeft, 0, titleRight - titleLeft, insets.top - 2);
            }
            g.setColor(this.getColor(c, false, false, Position.MOVE));
            g.drawLine(titleLeft, insets.top - 2, titleRight - 1, insets.top - 2);
            g.setColor(this.getColor(c, true, false, Position.MOVE));
            g.drawLine(titleLeft, insets.top - 1, titleRight - 1, insets.top - 1);
        }
        if (insets.top > 2) {
            g.setColor(this.getColor(c, Position.N));
            g.fillRect(corner, 0, titleLeft - corner, insets.top - 2);
            g.fillRect(titleRight, 0, width - corner - titleRight, insets.top - 2);
        }
        g.setColor(this.getColor(c, false, false, Position.N));
        g.drawLine(corner, insets.top - 2, titleLeft - 1, insets.top - 2);
        g.drawLine(titleRight, insets.top - 2, width - corner - 1, insets.top - 2);
        g.setColor(this.getColor(c, true, false, Position.N));
        g.drawLine(corner, insets.top - 1, titleLeft - 1, insets.top - 1);
        g.drawLine(titleRight, insets.top - 1, width - corner - 1, insets.top - 1);
        if (insets.top > 2) {
            g.setColor(this.getColor(c, Position.NW));
            g.fillRect(0, 0, corner, insets.top - 2);
        }
        if (insets.left > 2) {
            g.setColor(this.getColor(c, Position.NW));
            g.fillRect(0, 0, insets.left - 2, corner);
        }
        g.setColor(this.getColor(c, false, false, Position.NW));
        g.drawLine(insets.left - 2, insets.top - 2, corner - 1, insets.top - 2);
        g.drawLine(insets.left - 2, insets.top - 2, insets.left - 2, corner - 1);
        g.setColor(this.getColor(c, true, false, Position.NW));
        g.drawLine(insets.left - 1, insets.top - 1, corner - 1, insets.top - 1);
        g.drawLine(insets.left - 1, insets.top - 1, insets.left - 1, corner - 1);
        if (insets.top > 2) {
            g.setColor(this.getColor(c, Position.NE));
            g.fillRect(width - corner, 0, corner, insets.top - 2);
        }
        if (insets.right > 2) {
            g.setColor(this.getColor(c, Position.NE));
            g.fillRect(width - insets.right + 2, 0, insets.right - 2, corner);
        }
        g.setColor(this.getColor(c, false, false, Position.NE));
        g.drawLine(width - corner, insets.top - 2, width - insets.right, insets.top - 2);
        g.setColor(this.getColor(c, false, true, Position.NE));
        g.drawLine(width - insets.right + 1, insets.top - 2, width - insets.right + 1, corner - 1);
        g.setColor(this.getColor(c, true, false, Position.NE));
        g.drawLine(width - corner, insets.top - 1, width - insets.right - 1, insets.top - 1);
        g.setColor(this.getColor(c, true, true, Position.NE));
        g.drawLine(width - insets.right, insets.top - 1, width - insets.right, corner - 1);
        if (insets.left > 2) {
            g.setColor(this.getColor(c, Position.W));
            g.fillRect(0, corner, insets.left - 2, height - 2 * corner);
        }
        g.setColor(this.getColor(c, false, false, Position.W));
        g.drawLine(insets.left - 2, corner, insets.left - 2, height - corner - 1);
        g.setColor(this.getColor(c, true, false, Position.W));
        g.drawLine(insets.left - 1, corner, insets.left - 1, height - corner - 1);
        if (insets.right > 2) {
            g.setColor(this.getColor(c, Position.E));
            g.fillRect(width - insets.right + 2, corner, insets.right - 2, height - 2 * corner);
        }
        g.setColor(this.getColor(c, false, true, Position.E));
        g.drawLine(width - insets.right + 1, corner, width - insets.right + 1, height - corner - 1);
        g.setColor(this.getColor(c, true, true, Position.E));
        g.drawLine(width - insets.right, corner, width - insets.right, height - corner - 1);
        if (insets.bottom > 2) {
            g.setColor(this.getColor(c, Position.S));
            g.fillRect(corner, height - insets.bottom + 2, width - 2 * corner, insets.bottom - 2);
        }
        g.setColor(this.getColor(c, true, true, Position.S));
        g.drawLine(corner, height - insets.bottom, width - corner - 1, height - insets.bottom);
        g.setColor(this.getColor(c, false, true, Position.S));
        g.drawLine(corner, height - insets.bottom + 1, width - corner - 1, height - insets.bottom + 1);
        if (insets.left > 2) {
            g.setColor(this.getColor(c, Position.SW));
            g.fillRect(0, height - corner, insets.left - 2, corner);
        }
        if (insets.bottom > 2) {
            g.setColor(this.getColor(c, Position.SW));
            g.fillRect(0, height - insets.bottom + 2, corner, insets.bottom - 2);
        }
        g.setColor(this.getColor(c, false, false, Position.SW));
        g.drawLine(insets.left - 2, height - corner, insets.left - 2, height - insets.bottom);
        g.setColor(this.getColor(c, true, false, Position.SW));
        g.drawLine(insets.left - 1, height - corner, insets.left - 1, height - insets.bottom - 1);
        g.setColor(this.getColor(c, true, true, Position.SW));
        g.drawLine(insets.left - 1, height - insets.bottom, corner - 1, height - insets.bottom);
        g.setColor(this.getColor(c, false, true, Position.SW));
        g.drawLine(insets.left - 2, height - insets.bottom + 1, corner - 1, height - insets.bottom + 1);
        if (insets.right > 2) {
            g.setColor(this.getColor(c, Position.SE));
            g.fillRect(width - insets.right + 2, height - corner, insets.right - 2, corner);
        }
        if (insets.bottom > 2) {
            g.setColor(this.getColor(c, Position.SE));
            g.fillRect(width - corner, height - insets.bottom + 2, corner, insets.bottom - 2);
        }
        g.setColor(this.getColor(c, true, true, Position.SE));
        g.drawLine(width - corner, height - insets.bottom, width - insets.right - 1, height - insets.bottom);
        g.drawLine(width - insets.right, height - corner, width - insets.right, height - insets.bottom);
        g.setColor(this.getColor(c, false, true, Position.SE));
        g.drawLine(width - corner, height - insets.bottom + 1, width - insets.right, height - insets.bottom + 1);
        g.drawLine(width - insets.right + 1, height - corner, width - insets.right + 1, height - insets.bottom + 1);
        if (this.drawDividers) {
            if (insets.top > 2) {
                g.setColor(this.getLine(c));
                g.drawLine(corner, 0, corner, insets.top - 3);
                g.drawLine(titleLeft, 0, titleLeft, insets.top - 3);
                g.drawLine(titleRight - 1, 0, titleRight - 1, insets.top - 3);
                g.drawLine(width - corner - 1, 0, width - corner - 1, insets.top - 3);
            }
            g.setColor(this.getLine(c, true, false));
            g.drawLine(corner, insets.top - 1, corner, insets.top - 1);
            g.drawLine(titleLeft, insets.top - 1, titleLeft, insets.top - 1);
            g.drawLine(titleRight - 1, insets.top - 1, titleRight - 1, insets.top - 1);
            g.drawLine(width - corner - 1, insets.top - 1, width - corner - 1, insets.top - 1);
            g.setColor(this.getLine(c, false, false));
            g.drawLine(corner, insets.top - 2, corner, insets.top - 2);
            g.drawLine(titleLeft, insets.top - 2, titleLeft, insets.top - 2);
            g.drawLine(titleRight - 1, insets.top - 21, titleRight - 1, insets.top - 2);
            g.drawLine(width - corner - 1, insets.top - 2, width - corner - 1, insets.top - 2);
            if (insets.bottom > 2) {
                g.setColor(this.getLine(c));
                g.drawLine(corner, height - insets.bottom + 2, corner, height - 1);
                g.drawLine(width - corner - 1, height - insets.bottom + 2, width - corner - 1, height - 1);
            }
            g.setColor(this.getLine(c, true, false));
            g.drawLine(corner, height - insets.bottom, corner, height - insets.bottom);
            g.drawLine(width - corner - 1, height - insets.bottom, width - corner - 1, height - insets.bottom);
            g.setColor(this.getLine(c, false, false));
            g.drawLine(corner, height - insets.bottom + 1, corner, height - insets.bottom + 1);
            g.drawLine(width - corner - 1, height - insets.bottom + 1, width - corner - 1, height - insets.bottom + 1);
            if (insets.left > 2) {
                g.setColor(this.getLine(c));
                g.drawLine(0, corner, insets.left - 3, corner);
                g.drawLine(0, height - corner - 1, insets.left - 3, height - corner - 1);
            }
            g.setColor(this.getLine(c, true, false));
            g.drawLine(insets.left - 1, corner, insets.left - 1, corner);
            g.drawLine(insets.left - 1, height - corner - 1, insets.left - 1, height - corner - 1);
            g.setColor(this.getLine(c, false, false));
            g.drawLine(insets.left - 2, corner, insets.left - 2, corner);
            g.drawLine(insets.left - 2, height - corner - 1, insets.left - 2, height - corner - 1);
            if (insets.right > 2) {
                g.setColor(this.getLine(c));
                g.drawLine(width - insets.right + 2, corner, width - 1, corner);
                g.drawLine(width - insets.right + 2, height - corner - 1, width - 1, height - corner - 1);
            }
            g.setColor(this.getLine(c, true, false));
            g.drawLine(width - insets.right, corner, width - insets.right, corner);
            g.drawLine(width - insets.right, height - corner - 1, width - insets.right, height - corner - 1);
            g.setColor(this.getLine(c, false, false));
            g.drawLine(width - insets.right + 1, corner, width - insets.right + 1, corner);
            g.drawLine(width - insets.right + 1, height - corner - 1, width - insets.right + 1, height - corner - 1);
        }
        g.translate(-x, -y);
        g.setColor(oldColor);
    }

    protected Color getLine(Component c) {
        Color color = (Color)this.colorLine.value();
        if (color == null) {
            return c.getForeground();
        }
        return color;
    }

    protected Color getLine(Component c, boolean inner, boolean shadow) {
        Color color = inner && shadow ? (Color)this.colorLineShadowInner.value() : (inner && !shadow ? (Color)this.colorLineHighlightInner.value() : (!inner && shadow ? (Color)this.colorLineShadowOuter.value() : (Color)this.colorLineHighlightOuter.value()));
        if (color != null) {
            return color;
        }
        return this.defaultModify(this.getLine(c), inner, shadow);
    }

    private Color getColor(Component c, Position position) {
        if (position == this.mousePressed) {
            return this.getSelectedColor(c);
        }
        if (position == this.mouseOver) {
            return this.getHoverColor(c);
        }
        return this.getNormalColor(c);
    }

    private Color getColor(Component c, boolean inner, boolean shadow, Position position) {
        if (position == this.mousePressed) {
            return this.getSelectedColor(c, inner, shadow);
        }
        if (position == this.mouseOver) {
            return this.getHoverColor(c, inner, shadow);
        }
        return this.getNormalColor(c, inner, shadow);
    }

    protected Color getHoverColor(Component c) {
        Color color = (Color)this.colorHover.value();
        if (color == null) {
            return Color.YELLOW;
        }
        return color;
    }

    protected Color getHoverColor(Component c, boolean inner, boolean shadow) {
        Color color = inner && shadow ? (Color)this.colorShadowInnerHover.value() : (inner && !shadow ? (Color)this.colorHighlightInnerHover.value() : (!inner && shadow ? (Color)this.colorShadowOuterHover.value() : (Color)this.colorHighlightOuterHover.value()));
        if (color != null) {
            return color;
        }
        return this.defaultModify(this.getHoverColor(c), inner, shadow);
    }

    protected Color getSelectedColor(Component c) {
        Color color = (Color)this.colorSelected.value();
        if (color == null) {
            return Color.RED;
        }
        return color;
    }

    protected Color getSelectedColor(Component c, boolean inner, boolean shadow) {
        Color color = inner && shadow ? (Color)this.colorShadowInnerSelected.value() : (inner && !shadow ? (Color)this.colorHighlightInnerSelected.value() : (!inner && shadow ? (Color)this.colorShadowOuterSelected.value() : (Color)this.colorHighlightOuterSelected.value()));
        if (color != null) {
            return color;
        }
        return this.defaultModify(this.getSelectedColor(c), inner, shadow);
    }

    protected Color getNormalColor(Component c) {
        Color color = (Color)this.color.value();
        if (color == null) {
            return c.getBackground();
        }
        return color;
    }

    protected Color getNormalColor(Component c, boolean inner, boolean shadow) {
        Color color = inner && shadow ? (Color)this.colorShadowInner.value() : (inner && !shadow ? (Color)this.colorHighlightInner.value() : (!inner && shadow ? (Color)this.colorShadowOuter.value() : (Color)this.colorHighlightOuter.value()));
        if (color != null) {
            return color;
        }
        return this.defaultModify(this.getNormalColor(c), inner, shadow);
    }

    protected Color defaultModify(Color color, boolean inner, boolean shadow) {
        if (inner && shadow) {
            return Colors.darker(color, 0.2);
        }
        if (!inner && shadow) {
            return Colors.darker(color, 0.4);
        }
        if (inner && !shadow) {
            return Colors.brighter(color, 0.2);
        }
        return Colors.brighter(color, 0.4);
    }

    protected class BorderColor
    extends AbstractDockColor
    implements ScreenDockWindowColor {
        public BorderColor(String id) {
            super("station.screen.border." + id, KIND_SCREEN_WINDOW_COLOR);
        }

        public BorderColor() {
            super("station.screen.border", KIND_SCREEN_WINDOW_COLOR);
        }

        protected void changed(Color oldValue, Color newValue) {
            ScreenDockWindowBorder.this.target.repaint();
        }

        public ScreenDockWindow getWindow() {
            return ScreenDockWindowBorder.this.window;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Position {
        N,
        E,
        S,
        W,
        NE,
        SW,
        NW,
        SE,
        MOVE,
        NOTHING;

    }
}

