/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextarea;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import org.fife.ui.rtextarea.RTextArea;

class LineHighlightManager {
    private RTextArea textArea;
    private List lineHighlights;

    public LineHighlightManager(RTextArea rTextArea) {
        this.textArea = rTextArea;
    }

    public Object addLineHighlight(int n, Color color) throws BadLocationException {
        int n2;
        int n3 = this.textArea.getLineStartOffset(n);
        LineHighlightInfo lineHighlightInfo = new LineHighlightInfo(this.textArea.getDocument().createPosition(n3), color);
        if (this.lineHighlights == null) {
            this.lineHighlights = new ArrayList(1);
        }
        if ((n2 = Collections.binarySearch(this.lineHighlights, lineHighlightInfo)) < 0) {
            n2 = -(n2 + 1);
        }
        this.lineHighlights.add(n2, lineHighlightInfo);
        this.repaintLine(lineHighlightInfo);
        return lineHighlightInfo;
    }

    public void paintLineHighlights(Graphics graphics) {
        int n;
        int n2 = n = this.lineHighlights == null ? 0 : this.lineHighlights.size();
        if (n > 0) {
            int n3 = this.textArea.getDocument().getLength();
            Rectangle rectangle = this.textArea.getVisibleRect();
            int n4 = this.textArea.getLineHeight();
            try {
                for (int i = 0; i < n; ++i) {
                    int n5;
                    LineHighlightInfo lineHighlightInfo = (LineHighlightInfo)this.lineHighlights.get(i);
                    int n6 = lineHighlightInfo.getOffset();
                    if (n6 < 0 || n6 > n3 || (n5 = this.textArea.yForLineContaining(n6)) <= rectangle.y - n4) continue;
                    if (n5 < rectangle.y + rectangle.height) {
                        graphics.setColor(lineHighlightInfo.getColor());
                        graphics.fillRect(0, n5, this.textArea.getWidth(), n4);
                        continue;
                    }
                    break;
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
    }

    public void removeAllLineHighlights() {
        if (this.lineHighlights != null) {
            this.lineHighlights.clear();
            this.textArea.repaint();
        }
    }

    public void removeLineHighlight(Object object) {
        if (object instanceof LineHighlightInfo) {
            this.lineHighlights.remove(object);
            this.repaintLine((LineHighlightInfo)object);
        }
    }

    private void repaintLine(LineHighlightInfo lineHighlightInfo) {
        int n = lineHighlightInfo.getOffset();
        if (n >= 0 && n <= this.textArea.getDocument().getLength()) {
            try {
                int n2 = this.textArea.yForLineContaining(n);
                if (n2 > -1) {
                    this.textArea.repaint(0, n2, this.textArea.getWidth(), this.textArea.getLineHeight());
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
    }

    private static class LineHighlightInfo
    implements Comparable {
        private Position offs;
        private Color color;

        public LineHighlightInfo(Position position, Color color) {
            this.offs = position;
            this.color = color;
        }

        public int compareTo(Object object) {
            if (object instanceof LineHighlightInfo) {
                return this.offs.getOffset() - ((LineHighlightInfo)object).getOffset();
            }
            return -1;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof LineHighlightInfo) {
                return this.offs.getOffset() == ((LineHighlightInfo)object).getOffset();
            }
            return false;
        }

        public Color getColor() {
            return this.color;
        }

        public int getOffset() {
            return this.offs.getOffset();
        }

        public int hashCode() {
            return this.getOffset();
        }
    }
}

