/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.perspective;

import bibliothek.gui.dock.DockFactory;
import bibliothek.gui.dock.layout.DockLayout;
import bibliothek.gui.dock.layout.DockLayoutComposition;
import bibliothek.gui.dock.layout.DockLayoutInfo;
import bibliothek.gui.dock.layout.DockSituation;
import bibliothek.gui.dock.layout.DockSituationIgnore;
import bibliothek.gui.dock.perspective.PerspectiveDockable;
import bibliothek.gui.dock.perspective.PerspectiveElement;
import bibliothek.gui.dock.perspective.PerspectiveStation;
import bibliothek.util.xml.XElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Perspective {
    private DockSituation situation;

    public Perspective(DockSituation situation) {
        this.situation = situation;
    }

    public Map<String, PerspectiveStation> readXML(XElement root) {
        Map<String, DockLayoutComposition> map = this.situation.readCompositionsXML(root);
        HashMap<String, PerspectiveStation> result = new HashMap<String, PerspectiveStation>();
        for (Map.Entry<String, DockLayoutComposition> entry : map.entrySet()) {
            PerspectiveElement element = this.convert(entry.getValue());
            PerspectiveStation station = element == null ? null : element.asStation();
            if (station == null) continue;
            result.put(entry.getKey(), station);
        }
        return result;
    }

    public void writeXML(Map<String, PerspectiveStation> stations, XElement element) {
        HashMap<String, DockLayoutComposition> map = new HashMap<String, DockLayoutComposition>();
        for (Map.Entry<String, PerspectiveStation> entry : stations.entrySet()) {
            DockLayoutComposition composition = this.convert(entry.getValue());
            if (composition == null) continue;
            map.put(entry.getKey(), composition);
        }
        this.situation.writeCompositionsXML(map, element);
    }

    public Map<String, PerspectiveStation> read(DataInputStream in) throws IOException {
        Map<String, DockLayoutComposition> map = this.situation.readCompositions(in);
        HashMap<String, PerspectiveStation> result = new HashMap<String, PerspectiveStation>();
        for (Map.Entry<String, DockLayoutComposition> entry : map.entrySet()) {
            PerspectiveElement element = this.convert(entry.getValue());
            PerspectiveStation station = element == null ? null : element.asStation();
            if (station == null) continue;
            result.put(entry.getKey(), station);
        }
        return result;
    }

    public void write(Map<String, PerspectiveStation> stations, DataOutputStream out) throws IOException {
        HashMap<String, DockLayoutComposition> map = new HashMap<String, DockLayoutComposition>();
        for (Map.Entry<String, PerspectiveStation> entry : stations.entrySet()) {
            DockLayoutComposition composition = this.convert(entry.getValue());
            if (composition == null) continue;
            map.put(entry.getKey(), composition);
        }
        this.situation.writeCompositions(map, out);
    }

    public DockLayoutComposition convert(PerspectiveElement element) {
        PerspectiveDockable dockable;
        DockSituationIgnore ignore = this.situation.getIgnore();
        if (ignore != null && ignore.ignoreElement(element)) {
            return null;
        }
        String id = this.getID(element);
        DockFactory<?, ?, ?> factory = this.getFactory(id);
        if (factory == null) {
            throw new IllegalArgumentException("missing factory: " + element.getFactoryID());
        }
        HashMap<PerspectiveDockable, Integer> ids = new HashMap<PerspectiveDockable, Integer>();
        ArrayList<DockLayoutComposition> children = new ArrayList<DockLayoutComposition>();
        boolean ignoreChildren = false;
        PerspectiveStation station = element.asStation();
        if (station != null) {
            if (ignore == null || !ignore.ignoreChildren(station)) {
                int index = 0;
                int n = station.getDockableCount();
                for (int i = 0; i < n; ++i) {
                    dockable = station.getDockable(i);
                    DockLayoutComposition composition = this.convert(dockable);
                    if (composition == null) continue;
                    children.add(composition);
                    ids.put(dockable, index++);
                }
            } else {
                ignoreChildren = true;
            }
        }
        Object data = factory.getPerspectiveLayout(element, ids);
        DockLayout layout = new DockLayout(id, data);
        DockLayoutInfo info = new DockLayoutInfo(layout);
        dockable = element.asDockable();
        if (dockable != null) {
            info.setPlaceholder(dockable.getPlaceholder());
        }
        return new DockLayoutComposition(info, null, children, ignoreChildren);
    }

    public PerspectiveElement convert(DockLayoutComposition composition) {
        DockLayoutInfo info = composition.getLayout();
        if (info == null) {
            return null;
        }
        DockLayout<?> layout = info.getDataLayout();
        if (layout == null) {
            return null;
        }
        DockFactory<?, ?, ?> factory = this.getFactory(layout.getFactoryID());
        if (factory == null) {
            return null;
        }
        PerspectiveElement result = null;
        if (composition.isIgnoreChildren()) {
            for (DockLayoutComposition childComposition : composition.getChildren()) {
                this.convert(childComposition);
            }
            result = (PerspectiveElement)factory.layoutPerspective(layout.getData(), null);
        } else {
            HashMap<Integer, PerspectiveDockable> children = new HashMap<Integer, PerspectiveDockable>();
            int index = 0;
            for (DockLayoutComposition childComposition : composition.getChildren()) {
                PerspectiveDockable dockable;
                PerspectiveElement child = this.convert(childComposition);
                if (child != null && (dockable = child.asDockable()) != null) {
                    children.put(index, dockable);
                }
                ++index;
            }
            result = (PerspectiveElement)factory.layoutPerspective(layout.getData(), children);
        }
        return result;
    }

    public DockSituation getSituation() {
        return this.situation;
    }

    protected abstract String getID(PerspectiveElement var1);

    protected abstract DockFactory<?, ?, ?> getFactory(String var1);
}

