/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.action.panel;

import bibliothek.gui.dock.common.action.CPanelPopup;
import bibliothek.gui.dock.common.action.panel.AbstractPanelPopupWindow;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;

public class DialogWindow
extends AbstractPanelPopupWindow {
    private JDialog dialog;
    private CPanelPopup panel;
    private WindowListener listener = new WindowAdapter(){

        public void windowClosed(WindowEvent windowEvent) {
            DialogWindow.this.closing();
        }

        public void windowClosing(WindowEvent windowEvent) {
            DialogWindow.this.closing();
        }

        public void windowDeactivated(WindowEvent windowEvent) {
            if (DialogWindow.this.panel.isCloseOnFocusLost()) {
                DialogWindow.this.close();
            }
        }
    };

    public DialogWindow(Component component, CPanelPopup cPanelPopup) {
        this.panel = cPanelPopup;
        this.dialog = this.createDialog(component);
        this.dialog.setDefaultCloseOperation(0);
        this.dialog.addWindowListener(this.listener);
    }

    public void setUndecorated(boolean bl) {
        this.dialog.setUndecorated(bl);
    }

    public void setContent(Component component) {
        this.dialog.getContentPane().removeAll();
        if (component != null) {
            this.dialog.add(component);
        }
    }

    public void open(int n, int n2) {
        this.dialog.pack();
        this.dialog.setLocation(n, n2);
        this.dialog.setVisible(true);
    }

    public void open(Component component) {
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(component);
        this.dialog.setVisible(true);
    }

    public boolean isOpen() {
        return this.dialog.isVisible();
    }

    public void close() {
        this.dialog.setVisible(false);
    }

    private void closing() {
        this.dialog.dispose();
        this.dialog.removeWindowListener(this.listener);
        this.fireClosed();
    }

    protected JDialog createDialog(Component component) {
        Window window = SwingUtilities.getWindowAncestor(component);
        if (window instanceof Frame) {
            return new JDialog((Frame)window);
        }
        if (window instanceof Dialog) {
            return new JDialog((Dialog)window);
        }
        return new JDialog();
    }
}

