/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.util;

import bibliothek.gui.dock.util.UIProperties;
import bibliothek.gui.dock.util.UIValue;
import bibliothek.util.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractUIValue<V, U extends UIValue<V>>
implements UIValue<V> {
    private V override;
    private V value;
    private V backup;
    private String id;
    private Path kind;
    private UIProperties<V, U, ?> manager;

    public AbstractUIValue(String string) {
        this(string, null, null);
    }

    public AbstractUIValue(String string, Path path) {
        this(string, path, null);
    }

    public AbstractUIValue(String string, V v) {
        this(string, null, v);
    }

    public AbstractUIValue(String string, Path path, V v) {
        if (string == null) {
            throw new IllegalArgumentException("id must no be null");
        }
        if (path == null) {
            throw new IllegalArgumentException("kind must not be null");
        }
        this.id = string;
        this.kind = path;
        this.backup = v;
    }

    protected abstract U me();

    public void setId(String string) {
        if (string == null) {
            throw new IllegalArgumentException("id must not be null");
        }
        this.id = string;
        if (this.manager != null) {
            U u = this.me();
            this.manager.remove(u);
            this.manager.add(string, this.kind, u);
        }
    }

    public String getId() {
        return this.id;
    }

    public void setKind(Path path) {
        if (path == null) {
            throw new IllegalArgumentException("kind must not be null");
        }
        this.kind = path;
        if (this.manager != null) {
            U u = this.me();
            this.manager.remove(u);
            this.manager.add(this.id, path, u);
        }
    }

    public Path getKind() {
        return this.kind;
    }

    public void setManager(UIProperties<V, U, ?> uIProperties) {
        if (uIProperties != this.manager) {
            U u = this.me();
            if (this.manager != null) {
                this.manager.remove(u);
            }
            this.manager = uIProperties;
            if (this.manager != null) {
                this.manager.add(this.id, this.kind, u);
            }
        }
    }

    @Override
    public void set(V v) {
        V v2 = this.value();
        this.value = v;
        V v3 = this.value();
        if (v2 != v3) {
            this.changed(v2, v3);
        }
    }

    public V value() {
        if (this.override != null) {
            return this.override;
        }
        if (this.value != null) {
            return this.value;
        }
        return this.backup;
    }

    protected abstract void changed(V var1, V var2);

    public void setValue(V v) {
        V v2 = this.value();
        this.override = v;
        V v3 = this.value();
        if (v2 != v3) {
            this.changed(v2, v3);
        }
    }

    public V getValue() {
        return this.override;
    }

    public void setBackup(V v) {
        V v2 = this.value();
        this.backup = v;
        V v3 = this.value();
        if (v2 != v3) {
            this.changed(v2, v3);
        }
    }

    public V getBackup() {
        return this.backup;
    }
}

