/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.support;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.gui.dock.station.support.PlaceholderStrategyListener;
import bibliothek.util.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RootPlaceholderStrategy
implements PlaceholderStrategy {
    private DockStation station;
    private List<PlaceholderStrategyListener> listeners;
    private PlaceholderStrategy strategy;
    private Set<Path> placeholders = new HashSet<Path>();
    private PlaceholderStrategyListener listener = new PlaceholderStrategyListener(){

        @Override
        public void placeholderInvalidated(Set<Path> set) {
            RootPlaceholderStrategy.this.placeholders.removeAll(set);
        }
    };

    public RootPlaceholderStrategy(DockStation dockStation) {
        this.station = dockStation;
    }

    public void setStrategy(PlaceholderStrategy placeholderStrategy) {
        if (this.strategy != placeholderStrategy) {
            if (this.strategy != null) {
                this.strategy.removeListener(this.listener);
                this.strategy.uninstall(this.station);
            }
            this.strategy = placeholderStrategy;
            if (this.strategy == null) {
                if (!this.placeholders.isEmpty()) {
                    this.fireRemoved(Collections.unmodifiableSet(this.placeholders));
                    this.placeholders.clear();
                }
            } else {
                this.strategy.install(this.station);
                this.strategy.addListener(this.listener);
                HashSet<Path> hashSet = new HashSet<Path>();
                Iterator<Path> iterator = this.placeholders.iterator();
                while (iterator.hasNext()) {
                    Path path = iterator.next();
                    if (this.strategy.isValidPlaceholder(path)) continue;
                    iterator.remove();
                    hashSet.add(path);
                }
                if (!hashSet.isEmpty()) {
                    this.fireRemoved(hashSet);
                }
            }
        }
    }

    private void fireRemoved(Set<Path> set) {
        for (PlaceholderStrategyListener placeholderStrategyListener : this.listeners.toArray(new PlaceholderStrategyListener[this.listeners.size()])) {
            placeholderStrategyListener.placeholderInvalidated(set);
        }
    }

    public PlaceholderStrategy getStrategy() {
        return this.strategy;
    }

    @Override
    public void addListener(PlaceholderStrategyListener placeholderStrategyListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<PlaceholderStrategyListener>();
        }
        this.listeners.add(placeholderStrategyListener);
        if (this.strategy != null) {
            this.strategy.addListener(placeholderStrategyListener);
        }
    }

    @Override
    public void removeListener(PlaceholderStrategyListener placeholderStrategyListener) {
        if (this.listeners != null) {
            this.listeners.remove(placeholderStrategyListener);
        }
        if (this.strategy != null) {
            this.strategy.removeListener(placeholderStrategyListener);
        }
    }

    @Override
    public Path getPlaceholderFor(Dockable dockable) {
        if (this.strategy == null) {
            return null;
        }
        Path path = this.strategy.getPlaceholderFor(dockable);
        if (path != null) {
            this.placeholders.add(path);
        }
        return path;
    }

    @Override
    public void install(DockStation dockStation) {
        throw new IllegalStateException("this strategy must not be installed");
    }

    @Override
    public boolean isValidPlaceholder(Path path) {
        if (this.strategy == null) {
            return false;
        }
        boolean bl = this.strategy.isValidPlaceholder(path);
        if (bl) {
            this.placeholders.add(path);
        }
        return bl;
    }

    @Override
    public void uninstall(DockStation dockStation) {
        throw new IllegalStateException("this strategy must not be uninstalled");
    }
}

