/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.stack;

import bibliothek.gui.DockController;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.DockElementRepresentative;
import bibliothek.gui.dock.station.stack.StackDockComponent;

public class StackDockComponentRepresentative {
    private DockController controller;
    private DockElement target;
    private StackDockComponent component;
    private DockElementRepresentative representative;

    public void setComponent(StackDockComponent stackDockComponent) {
        if (this.component != stackDockComponent) {
            this.clearRepresentative();
            this.component = stackDockComponent;
            this.buildRepresentative();
        }
    }

    public void setController(DockController dockController) {
        if (this.controller != dockController) {
            this.clearRepresentative();
            this.controller = dockController;
            this.buildRepresentative();
        }
    }

    public void setTarget(DockElement dockElement) {
        if (this.target != dockElement) {
            this.clearRepresentative();
            this.target = dockElement;
            this.buildRepresentative();
        }
    }

    private void clearRepresentative() {
        if (this.representative != null && this.controller != null) {
            this.controller.removeRepresentative(this.representative);
            this.representative = null;
        }
    }

    private void buildRepresentative() {
        if (this.controller != null && this.target != null && this.representative == null && this.component != null) {
            this.representative = this.component.createDefaultRepresentation(this.target);
            if (this.representative != null) {
                this.controller.addRepresentative(this.representative);
            }
        }
    }
}

