/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.split;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.station.split.Leaf;
import bibliothek.gui.dock.station.split.Node;
import bibliothek.gui.dock.station.split.PutInfo;
import bibliothek.gui.dock.station.split.Root;
import bibliothek.gui.dock.station.split.SplitLayoutManager;
import bibliothek.gui.dock.station.split.SplitNode;
import java.awt.Dimension;
import java.awt.Point;
import javax.swing.SwingUtilities;

public class DefaultSplitLayoutManager
implements SplitLayoutManager {
    public void install(SplitDockStation splitDockStation) {
    }

    public void uninstall(SplitDockStation splitDockStation) {
    }

    public Dockable willMakeFullscreen(SplitDockStation splitDockStation, Dockable dockable) {
        return dockable;
    }

    public PutInfo prepareDrop(SplitDockStation splitDockStation, int n, int n2, int n3, int n4, boolean bl, Dockable dockable) {
        DockStation dockStation;
        if (splitDockStation.isFullScreen()) {
            return null;
        }
        if (splitDockStation.getDockableCount() == 0) {
            DockStation dockStation2 = splitDockStation.getDockParent();
            if (dockStation2 != null && bl && dockStation2.isInOverrideZone(n, n2, splitDockStation, dockable)) {
                return null;
            }
            PutInfo putInfo = new PutInfo(null, PutInfo.Put.CENTER, dockable);
            putInfo.setDockable(dockable);
            putInfo = this.validatePutInfo(splitDockStation, putInfo);
            return putInfo;
        }
        Point point = new Point(n, n2);
        SwingUtilities.convertPointFromScreen(point, splitDockStation);
        PutInfo putInfo = splitDockStation.getRoot().getPut(point.x, point.y, dockable);
        if (putInfo == null && splitDockStation.isAllowSideSnap()) {
            putInfo = this.calculateSideSnap(splitDockStation, point.x, point.y, null, dockable);
            putInfo = this.validatePutInfo(splitDockStation, putInfo);
        }
        if (putInfo != null) {
            putInfo.setDockable(dockable);
            this.calculateDivider(splitDockStation, putInfo, null);
        }
        if ((dockStation = splitDockStation.getDockParent()) != null && putInfo != null && bl && dockStation.isInOverrideZone(n, n2, splitDockStation, dockable)) {
            if (putInfo.getPut() == PutInfo.Put.CENTER) {
                return null;
            }
            return putInfo;
        }
        return putInfo;
    }

    public PutInfo prepareMove(SplitDockStation splitDockStation, int n, int n2, int n3, int n4, boolean bl, Dockable dockable) {
        DockStation dockStation;
        if (splitDockStation.isFullScreen()) {
            return null;
        }
        Point point = new Point(n, n2);
        SwingUtilities.convertPointFromScreen(point, splitDockStation);
        Root root = splitDockStation.getRoot();
        PutInfo putInfo = root.getPut(point.x, point.y, dockable);
        Leaf leaf = root.getLeaf(dockable);
        if (putInfo == null && splitDockStation.isAllowSideSnap()) {
            putInfo = this.calculateSideSnap(splitDockStation, point.x, point.y, leaf, dockable);
            putInfo = this.validatePutInfo(splitDockStation, putInfo);
        }
        if (putInfo != null && putInfo.getNode() instanceof Leaf && ((Leaf)putInfo.getNode()).getDockable() == dockable) {
            putInfo = null;
        }
        if (putInfo != null) {
            putInfo.setDockable(dockable);
            this.calculateDivider(splitDockStation, putInfo, leaf);
        }
        if ((dockStation = splitDockStation.getDockParent()) != null && putInfo != null && bl && dockStation.isInOverrideZone(n, n2, splitDockStation, dockable) && putInfo.getPut() == PutInfo.Put.CENTER) {
            return null;
        }
        return putInfo;
    }

    protected PutInfo calculateSideSnap(SplitDockStation splitDockStation, int n, int n2, Leaf leaf, Dockable dockable) {
        if (splitDockStation.getDockableCount() == 0) {
            return null;
        }
        PutInfo putInfo = SplitNode.above(0.0, 0.0, splitDockStation.getWidth(), splitDockStation.getHeight(), n, n2) ? (SplitNode.above(0.0, splitDockStation.getHeight(), splitDockStation.getWidth(), 0.0, n, n2) ? new PutInfo(splitDockStation.getRoot().getChild(), PutInfo.Put.TOP, dockable) : new PutInfo(splitDockStation.getRoot().getChild(), PutInfo.Put.RIGHT, dockable)) : (SplitNode.above(0.0, splitDockStation.getHeight(), splitDockStation.getWidth(), 0.0, n, n2) ? new PutInfo(splitDockStation.getRoot().getChild(), PutInfo.Put.LEFT, dockable) : new PutInfo(splitDockStation.getRoot().getChild(), PutInfo.Put.BOTTOM, dockable));
        if (leaf != null && splitDockStation.getRoot().getChild() instanceof Node) {
            Node node = (Node)splitDockStation.getRoot().getChild();
            if (putInfo.getPut() == PutInfo.Put.TOP && node.getOrientation() == SplitDockStation.Orientation.VERTICAL && node.getLeft() == leaf) {
                return null;
            }
            if (putInfo.getPut() == PutInfo.Put.BOTTOM && node.getOrientation() == SplitDockStation.Orientation.VERTICAL && node.getLeft() == leaf) {
                return null;
            }
            if (putInfo.getPut() == PutInfo.Put.LEFT && node.getOrientation() == SplitDockStation.Orientation.HORIZONTAL && node.getLeft() == leaf) {
                return null;
            }
            if (putInfo.getPut() == PutInfo.Put.RIGHT && node.getOrientation() == SplitDockStation.Orientation.HORIZONTAL && node.getLeft() == leaf) {
                return null;
            }
        }
        return putInfo;
    }

    public void calculateDivider(SplitDockStation splitDockStation, PutInfo putInfo, Leaf leaf) {
        SplitNode splitNode = putInfo.getNode();
        Dimension dimension = leaf == null ? putInfo.getDockable().getComponent().getSize() : leaf.getSize();
        Dimension dimension2 = splitNode.getSize();
        int n = Math.min(dimension.width, dimension.height);
        if (leaf != null) {
            if (leaf.getParent() instanceof Node) {
                Node node = (Node)leaf.getParent();
                if ((putInfo.getPut() == PutInfo.Put.LEFT || putInfo.getPut() == PutInfo.Put.RIGHT) && node.getOrientation() == SplitDockStation.Orientation.HORIZONTAL) {
                    n = dimension.width;
                } else if ((putInfo.getPut() == PutInfo.Put.TOP || putInfo.getPut() == PutInfo.Put.BOTTOM) && node.getOrientation() == SplitDockStation.Orientation.VERTICAL) {
                    n = dimension.height;
                }
            }
        } else if (putInfo.getOldSize() != 0) {
            n = putInfo.getOldSize();
        }
        double d = 0.5;
        int n2 = splitDockStation.getDividerSize();
        if (putInfo.getPut() == PutInfo.Put.TOP) {
            if (n != 0) {
                d = ((double)n + (double)n2 / 2.0) / (double)dimension2.height;
            }
            if ((d = this.validateDivider(splitDockStation, d, putInfo.getDockable().getComponent().getMinimumSize(), splitNode.getMinimumSize(), SplitDockStation.Orientation.VERTICAL, splitNode.getWidth(), splitNode.getHeight())) > 0.75) {
                d = 0.75;
            }
        } else if (putInfo.getPut() == PutInfo.Put.BOTTOM) {
            if (n != 0) {
                d = 1.0 - ((double)n + (double)n2 / 2.0) / (double)dimension2.height;
            }
            if ((d = this.validateDivider(splitDockStation, d, splitNode.getMinimumSize(), putInfo.getDockable().getComponent().getMinimumSize(), SplitDockStation.Orientation.VERTICAL, splitNode.getWidth(), splitNode.getHeight())) < 0.25) {
                d = 0.25;
            }
        } else if (putInfo.getPut() == PutInfo.Put.LEFT) {
            if (n != 0) {
                d = ((double)n + (double)n2 / 2.0) / (double)dimension2.width;
            }
            if ((d = this.validateDivider(splitDockStation, d, putInfo.getDockable().getComponent().getMinimumSize(), splitNode.getMinimumSize(), SplitDockStation.Orientation.HORIZONTAL, splitNode.getWidth(), splitNode.getHeight())) > 0.75) {
                d = 0.75;
            }
        } else if (putInfo.getPut() == PutInfo.Put.RIGHT) {
            if (n != 0) {
                d = 1.0 - ((double)n + (double)n2 / 2.0) / (double)dimension2.width;
            }
            if ((d = this.validateDivider(splitDockStation, d, splitNode.getMinimumSize(), putInfo.getDockable().getComponent().getMinimumSize(), SplitDockStation.Orientation.HORIZONTAL, splitNode.getWidth(), splitNode.getHeight())) < 0.25) {
                d = 0.25;
            }
        }
        putInfo.setDivider(d);
        putInfo.setOldSize(n);
    }

    public double validateDivider(SplitDockStation splitDockStation, double d, Node node) {
        d = Math.min(1.0, Math.max(0.0, d));
        Dimension dimension = node.getLeft() == null ? new Dimension() : node.getLeft().getMinimumSize();
        Dimension dimension2 = node.getRight() == null ? new Dimension() : node.getRight().getMinimumSize();
        return this.validateDivider(splitDockStation, d, dimension, dimension2, node.getOrientation(), node.getWidth(), node.getHeight());
    }

    protected double validateDivider(SplitDockStation splitDockStation, double d, Dimension dimension, Dimension dimension2, SplitDockStation.Orientation orientation, double d2, double d3) {
        int n;
        int n2;
        double d4;
        double d5;
        if (orientation == SplitDockStation.Orientation.HORIZONTAL) {
            d5 = splitDockStation.getRoot().getWidthFactor();
            d4 = d2;
            n2 = dimension.width;
            n = dimension2.width;
        } else {
            d5 = splitDockStation.getRoot().getHeightFactor();
            d4 = d3;
            n2 = dimension.height;
            n = dimension2.height;
        }
        if (d5 <= 0.0 || Double.isNaN(d5)) {
            return d;
        }
        double d6 = (double)n2 / d5;
        double d7 = (double)n / d5;
        double d8 = (double)splitDockStation.getDividerSize() / d5;
        if (d6 + d7 + d8 >= d4) {
            d = (d6 + d8 / 2.0) / (d6 + d7 + d8);
        } else if (d * d4 < d6 + d8 / 2.0) {
            d = (d6 + d8 / 2.0) / d4;
        } else if (d * d4 > d4 - d7 - d8 / 2.0) {
            d = (d4 - d7 - d8 / 2.0) / d4;
        }
        return d;
    }

    public PutInfo validatePutInfo(SplitDockStation splitDockStation, PutInfo putInfo) {
        if (putInfo != null) {
            if (!splitDockStation.accept(putInfo.getDockable())) {
                return null;
            }
            if (putInfo.getNode() != null && (putInfo.getPut() == PutInfo.Put.CENTER || putInfo.getPut() == PutInfo.Put.TITLE) ? !putInfo.getDockable().accept(splitDockStation, ((Leaf)putInfo.getNode()).getDockable()) || !((Leaf)putInfo.getNode()).getDockable().accept(splitDockStation, putInfo.getDockable()) || !splitDockStation.getController().getAcceptance().accept(splitDockStation, ((Leaf)putInfo.getNode()).getDockable(), putInfo.getDockable()) : !putInfo.getDockable().accept(splitDockStation) || !splitDockStation.getController().getAcceptance().accept(splitDockStation, putInfo.getDockable())) {
                return null;
            }
        }
        return putInfo;
    }

    public void updateBounds(Root root, double d, double d2, double d3, double d4) {
        root.updateBounds(d, d2, 1.0, 1.0, d3, d4, true);
    }
}

