/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.flap;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.FlapDockStation;
import bibliothek.gui.dock.event.DockStationAdapter;
import bibliothek.gui.dock.station.flap.FlapLayoutManager;
import java.util.HashMap;
import java.util.Map;

public class DefaultFlapLayoutManager
implements FlapLayoutManager {
    private Map<FlapDockStation, Station> stations = new HashMap<FlapDockStation, Station>();

    public void install(FlapDockStation flapDockStation) {
        Station station = new Station();
        flapDockStation.addDockStationListener(station);
        station.size = flapDockStation.getDefaultWindowSize();
        this.stations.put(flapDockStation, station);
    }

    public void uninstall(FlapDockStation flapDockStation) {
        Station station = this.stations.remove(flapDockStation);
        if (station != null) {
            flapDockStation.removeDockStationListener(station);
        }
    }

    public int getSize(FlapDockStation flapDockStation, Dockable dockable) {
        return this.stations.get((Object)flapDockStation).size;
    }

    public boolean isHold(FlapDockStation flapDockStation, Dockable dockable) {
        return Boolean.TRUE.equals(this.stations.get((Object)flapDockStation).hold.get(dockable));
    }

    public void setHold(FlapDockStation flapDockStation, Dockable dockable, boolean bl) {
        this.stations.get((Object)flapDockStation).hold.put(dockable, bl);
    }

    public void setSize(FlapDockStation flapDockStation, Dockable dockable, int n) {
        this.stations.get((Object)flapDockStation).size = n;
    }

    private static class Station
    extends DockStationAdapter {
        public Map<Dockable, Boolean> hold = new HashMap<Dockable, Boolean>();
        public int size;

        private Station() {
        }

        public void dockableRemoved(DockStation dockStation, Dockable dockable) {
            this.hold.remove(dockable);
        }
    }
}

