/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.eclipse;

import bibliothek.extension.gui.dock.theme.EclipseTheme;
import bibliothek.extension.gui.dock.theme.eclipse.EclipseThemeConnector;
import bibliothek.gui.dock.title.DockTitleFactory;
import bibliothek.gui.dock.title.DockTitleRequest;

public class EclipseDockTitleFactory
implements DockTitleFactory {
    private EclipseTheme theme;
    private DockTitleFactory factory;

    public EclipseDockTitleFactory(EclipseTheme eclipseTheme, DockTitleFactory dockTitleFactory) {
        if (eclipseTheme == null) {
            throw new IllegalArgumentException("theme must not be null");
        }
        if (dockTitleFactory == null) {
            throw new IllegalArgumentException("factory must not be null");
        }
        this.theme = eclipseTheme;
        this.factory = dockTitleFactory;
    }

    public void install(DockTitleRequest dockTitleRequest) {
        this.factory.install(dockTitleRequest);
    }

    public void uninstall(DockTitleRequest dockTitleRequest) {
        this.factory.uninstall(dockTitleRequest);
    }

    public void request(DockTitleRequest dockTitleRequest) {
        EclipseThemeConnector.TitleBar titleBar = this.theme.getThemeConnector(dockTitleRequest.getVersion().getController()).getTitleBarKind(dockTitleRequest.getTarget());
        if (titleBar == EclipseThemeConnector.TitleBar.BASIC || titleBar == EclipseThemeConnector.TitleBar.BASIC_BORDERED) {
            this.factory.request(dockTitleRequest);
        } else {
            dockTitleRequest.answer(null);
        }
    }
}

