/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.bubble;

import bibliothek.extension.gui.dock.theme.bubble.BubbleColorAnimation;
import bibliothek.extension.gui.dock.theme.bubble.RoundButtonConnectable;
import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.themes.basic.action.BasicDropDownButtonHandler;
import bibliothek.gui.dock.themes.basic.action.BasicDropDownButtonModel;
import bibliothek.gui.dock.themes.color.ActionColor;
import bibliothek.gui.dock.util.DockUtilities;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.geom.RoundRectangle2D;
import javax.swing.Icon;
import javax.swing.JComponent;

public class RoundDropDownButton
extends JComponent
implements RoundButtonConnectable {
    private BubbleColorAnimation animation = new BubbleColorAnimation();
    private BasicDropDownButtonModel model;
    private BasicDropDownButtonHandler handler;
    private Icon dropIcon;
    private Icon disabledDropIcon;
    private RoundActionColor[] colors;

    public RoundDropDownButton(BasicDropDownButtonHandler basicDropDownButtonHandler, Dockable dockable, DockAction dockAction) {
        this.colors = new RoundActionColor[]{new RoundActionColor("action.dropdown", dockable, dockAction, Color.WHITE), new RoundActionColor("action.dropdown.enabled", dockable, dockAction, Color.LIGHT_GRAY), new RoundActionColor("action.dropdown.selected", dockable, dockAction, Color.YELLOW), new RoundActionColor("action.dropdown.enabled.selected", dockable, dockAction, Color.ORANGE), new RoundActionColor("action.dropdown.mouse.enabled", dockable, dockAction, Color.RED), new RoundActionColor("action.dropdown.mouse.selected.enabled", dockable, dockAction, new Color(128, 0, 0)), new RoundActionColor("action.dropdown.pressed.enabled", dockable, dockAction, Color.BLUE), new RoundActionColor("action.dropdown.pressed.selected.enabled", dockable, dockAction, Color.MAGENTA), new RoundActionColor("action.dropdown.focus", dockable, dockAction, Color.DARK_GRAY), new RoundActionColor("action.dropdown.enabled.focus", dockable, dockAction, Color.DARK_GRAY), new RoundActionColor("action.dropdown.selected.focus", dockable, dockAction, Color.DARK_GRAY), new RoundActionColor("action.dropdown.enabled.selected.focus", dockable, dockAction, Color.DARK_GRAY), new RoundActionColor("action.dropdown.mouse.enabled.focus", dockable, dockAction, Color.DARK_GRAY), new RoundActionColor("action.dropdown.mouse.selected.enabled.focus", dockable, dockAction, Color.DARK_GRAY), new RoundActionColor("action.dropdown.pressed.enabled.focus", dockable, dockAction, Color.DARK_GRAY), new RoundActionColor("action.dropdown.pressed.selected.enabled.focus", dockable, dockAction, Color.DARK_GRAY), new RoundActionColor("action.dropdown.line", dockable, dockAction, Color.DARK_GRAY), new RoundActionColor("action.dropdown.line.enabled", dockable, dockAction, Color.DARK_GRAY), new RoundActionColor("action.dropdown.line.selected", dockable, dockAction, Color.DARK_GRAY), new RoundActionColor("action.dropdown.line.enabled.selected", dockable, dockAction, Color.DARK_GRAY), new RoundActionColor("action.dropdown.line.mouse.enabled", dockable, dockAction, Color.DARK_GRAY), new RoundActionColor("action.dropdown.line.mouse.selected.enabled", dockable, dockAction, Color.DARK_GRAY), new RoundActionColor("action.dropdown.line.pressed.enabled", dockable, dockAction, Color.DARK_GRAY), new RoundActionColor("action.dropdown.line.pressed.selected.enabled", dockable, dockAction, Color.DARK_GRAY)};
        this.animation.addTask(new Runnable(){

            public void run() {
                RoundDropDownButton.this.repaint();
            }
        });
        this.handler = basicDropDownButtonHandler;
        this.dropIcon = this.createDropIcon();
        this.model = new BasicDropDownButtonModel(this, basicDropDownButtonHandler){

            public void changed() {
                RoundDropDownButton.this.updateColors();
                RoundDropDownButton.this.revalidate();
                RoundDropDownButton.this.repaint();
            }

            protected boolean inDropDownArea(int n, int n2) {
                return RoundDropDownButton.this.overDropIcon(n, n2);
            }
        };
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                RoundDropDownButton.this.repaint();
            }

            public void focusLost(FocusEvent focusEvent) {
                RoundDropDownButton.this.repaint();
            }
        });
        this.updateColors();
    }

    public void setController(DockController dockController) {
        for (RoundActionColor roundActionColor : this.colors) {
            roundActionColor.connect(dockController);
        }
        this.animation.kick();
    }

    public BasicDropDownButtonModel getModel() {
        return this.model;
    }

    public void updateUI() {
        this.disabledDropIcon = null;
        super.updateUI();
        if (this.handler != null) {
            this.handler.updateUI();
        }
    }

    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        Dimension dimension = this.model.getMaxIconSize();
        int n = Math.max(dimension.width, 10);
        int n2 = Math.max(dimension.height, 10);
        if (this.model.getOrientation().isHorizontal()) {
            return new Dimension((int)(1.5 * (double)n + 1.0 + 1.5 * (double)this.dropIcon.getIconWidth()), (int)(1.5 * (double)n2));
        }
        return new Dimension((int)(1.5 * (double)n), (int)(1.5 * (double)n2 + 1.0 + 1.5 * (double)this.dropIcon.getIconHeight()));
    }

    public boolean contains(int n, int n2) {
        if (!super.contains(n, n2)) {
            return false;
        }
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        RoundRectangle2D.Double double_ = this.model.getOrientation().isHorizontal() ? new RoundRectangle2D.Double(0.0, 0.0, n3, n4, n4, n4) : new RoundRectangle2D.Double(0.0, 0.0, n3, n4, n3, n3);
        return double_.contains(n, n2);
    }

    protected void paintComponent(Graphics graphics) {
        int n;
        Icon icon = this.dropIcon;
        if (!this.isEnabled()) {
            if (this.disabledDropIcon == null) {
                this.disabledDropIcon = DockUtilities.disabledIcon(this, this.dropIcon);
            }
            icon = this.disabledDropIcon;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n2 = 0;
        int n3 = 0;
        int n4 = this.getWidth();
        int n5 = this.getHeight();
        Dimension dimension = this.model.getMaxIconSize();
        Icon icon2 = this.model.getPaintIcon();
        int n6 = dimension.width < 10 ? 10 : dimension.width;
        int n7 = dimension.height < 10 ? 10 : dimension.height;
        int n8 = icon == null ? 5 : icon.getIconWidth();
        int n9 = n = icon == null ? 5 : icon.getIconHeight();
        if (this.model.getOrientation().isHorizontal()) {
            graphics2D.setColor(this.animation.getColor("background"));
            graphics2D.fillRoundRect(n2, n3, n4, n5, n5, n5);
            graphics2D.setColor(this.animation.getColor("mouse"));
            int n10 = n2 + (int)(0.625 * (double)n6 + 0.5 * ((double)n4 - 1.25 * (double)n8));
            graphics2D.drawLine(n10, n3 + 1, n10, n3 + n5 - 2);
            if (icon2 != null) {
                icon2.paintIcon(this, graphics, (int)((double)n2 + 0.25 * (double)n6), n3 + (n5 - n7) / 2);
            }
            if (icon != null) {
                icon.paintIcon(this, graphics, (int)((double)(n2 + n4) - 1.25 * (double)n8), n3 + (n5 - n) / 2);
            }
            if (this.hasFocus() && this.isFocusable() && this.isEnabled()) {
                Stroke stroke = graphics2D.getStroke();
                graphics2D.setStroke(new BasicStroke(3.0f));
                graphics2D.setColor(this.animation.getColor("focus"));
                graphics2D.drawRoundRect(n2 + 1, n3 + 1, n4 - 3, n5 - 3, n5, n5);
                graphics2D.setStroke(stroke);
            }
        } else {
            graphics2D.setColor(this.animation.getColor("background"));
            graphics2D.fillRoundRect(n2, n3, n4, n5, n4, n4);
            graphics2D.setColor(this.animation.getColor("mouse"));
            int n11 = n3 + (int)(0.625 * (double)n7 + 0.5 * ((double)n5 - 1.25 * (double)n));
            graphics2D.drawLine(n2 + 1, n11, n2 + n4 - 2, n11);
            if (icon2 != null) {
                icon2.paintIcon(this, graphics, n2 + (n4 - n6) / 2, (int)((double)n3 + 0.25 * (double)n7));
            }
            if (icon != null) {
                icon.paintIcon(this, graphics, n2 + (n4 - n8) / 2, (int)((double)(n3 + n5) - 1.25 * (double)n));
            }
            if (this.hasFocus() && this.isFocusable() && this.isEnabled()) {
                Stroke stroke = graphics2D.getStroke();
                graphics2D.setStroke(new BasicStroke(3.0f));
                graphics2D.setColor(this.animation.getColor("focus"));
                graphics2D.drawRoundRect(n2 + 1, n3 + 1, n4 - 3, n5 - 3, n4, n4);
                graphics2D.setStroke(stroke);
            }
        }
        graphics2D.dispose();
    }

    protected Icon createDropIcon() {
        return new Icon(){

            public int getIconHeight() {
                return 7;
            }

            public int getIconWidth() {
                return 7;
            }

            public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                graphics.setColor(RoundDropDownButton.this.getForeground());
                graphics.drawLine(++n, n2 + 1, n + 4, n2 + 1);
                graphics.drawLine(n + 1, n2 + 2, n + 3, n2 + 2);
                graphics.drawLine(n + 2, n2 + 3, n + 2, n2 + 3);
            }
        };
    }

    public boolean overDropIcon(int n, int n2) {
        int n3;
        if (!this.contains(n, n2)) {
            return false;
        }
        int n4 = 0;
        int n5 = 0;
        int n6 = this.getWidth();
        int n7 = this.getHeight();
        Dimension dimension = this.model.getMaxIconSize();
        int n8 = dimension.width < 10 ? 10 : dimension.width;
        int n9 = dimension.height < 10 ? 10 : dimension.height;
        int n10 = this.dropIcon == null ? 5 : this.dropIcon.getIconWidth();
        int n11 = n3 = this.dropIcon == null ? 5 : this.dropIcon.getIconHeight();
        if (this.model.getOrientation().isHorizontal()) {
            int n12 = n4 + (int)(0.625 * (double)n8 + 0.5 * ((double)n6 - 1.25 * (double)n10));
            return n >= n12;
        }
        int n13 = n5 + (int)(0.625 * (double)n9 + 0.5 * ((double)n7 - 1.25 * (double)n3));
        return n2 >= n13;
    }

    public void updateColors() {
        String string;
        String string2 = "";
        boolean bl = this.model.isSelected();
        boolean bl2 = this.model.isEnabled();
        boolean bl3 = this.model.isMousePressed();
        boolean bl4 = this.model.isMouseInside();
        boolean bl5 = this.model.isMouseOverDropDown();
        if (bl) {
            string2 = ".selected";
        }
        if (bl2) {
            string2 = string2 + ".enabled";
        }
        String string3 = bl5 && bl2 ? "dropdown.line" : "dropdown";
        if (bl3 && bl2) {
            string = "action.dropdown.pressed" + string2;
            string3 = "action." + string3 + ".pressed" + string2;
        } else if (bl4 && bl2) {
            string = "action.dropdown.mouse" + string2;
            string3 = "action." + string3 + ".mouse" + string2;
        } else {
            string = "action.dropdown" + string2;
            string3 = "action." + string3 + string2;
        }
        String string4 = string + ".focus";
        for (RoundActionColor roundActionColor : this.colors) {
            if (string.equals(roundActionColor.getId())) {
                this.animation.putColor("background", (Color)roundActionColor.value());
            }
            if (string3.equals(roundActionColor.getId())) {
                this.animation.putColor("mouse", (Color)roundActionColor.value());
            }
            if (!string4.equals(roundActionColor.getId())) continue;
            this.animation.putColor("focus", (Color)roundActionColor.value());
        }
    }

    private class RoundActionColor
    extends ActionColor {
        public RoundActionColor(String string, Dockable dockable, DockAction dockAction, Color color) {
            super(string, dockable, dockAction, color);
        }

        protected void changed(Color color, Color color2) {
            RoundDropDownButton.this.updateColors();
        }
    }
}

