/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.preference.editor;

import bibliothek.extension.gui.dock.preference.PreferenceEditor;
import bibliothek.extension.gui.dock.preference.PreferenceEditorCallback;
import bibliothek.extension.gui.dock.preference.PreferenceEditorFactory;
import bibliothek.extension.gui.dock.preference.PreferenceOperation;
import bibliothek.extension.gui.dock.preference.preferences.KeyStrokeValidator;
import bibliothek.gui.DockUI;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyStrokeEditor
extends JTextField
implements PreferenceEditor<KeyStroke> {
    public static final PreferenceEditorFactory<KeyStroke> FACTORY = new PreferenceEditorFactory<KeyStroke>(){

        @Override
        public PreferenceEditor<KeyStroke> create() {
            return new KeyStrokeEditor();
        }
    };
    private KeyStroke stroke;
    private KeyStrokeValidator validator = KeyStrokeValidator.EVERYTHING;
    private PreferenceEditorCallback<KeyStroke> callback;
    private boolean focused = false;

    public static final String toString(KeyStroke keyStroke, boolean bl) {
        int n;
        String string = "";
        int n2 = keyStroke.getModifiers();
        if (n2 != 0) {
            string = KeyEvent.getKeyModifiersText(n2);
            if (!bl) {
                string = string + "+";
            }
        }
        if (!KeyStrokeEditor.isModifierKey(n = keyStroke.getKeyCode())) {
            if (bl && n2 != 0) {
                string = string + "+";
            }
            string = n != 0 ? string + KeyEvent.getKeyText(n) : string + keyStroke.getKeyChar();
            if (!bl) {
                string = string + "+";
            }
        }
        return string;
    }

    public static boolean isModifierKey(int n) {
        switch (n) {
            case 16: 
            case 17: 
            case 18: 
            case 157: 
            case 65406: {
                return true;
            }
        }
        return false;
    }

    public KeyStrokeEditor() {
        this.setEditable(false);
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                KeyStrokeEditor.this.focused = true;
                KeyStrokeEditor.this.setValue(KeyStrokeEditor.this.stroke);
            }

            public void focusLost(FocusEvent focusEvent) {
                KeyStrokeEditor.this.focused = false;
                if (KeyStrokeEditor.this.callback != null) {
                    if (KeyStrokeEditor.this.stroke == null) {
                        KeyStrokeEditor.this.setValue((KeyStroke)KeyStrokeEditor.this.callback.get());
                    } else {
                        KeyStrokeEditor.this.callback.set(KeyStrokeEditor.this.stroke);
                    }
                } else {
                    KeyStrokeEditor.this.setValue(KeyStrokeEditor.this.stroke);
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                KeyStrokeEditor.this.setValue(KeyStroke.getKeyStrokeForEvent(keyEvent));
                KeyStroke keyStroke = KeyStrokeEditor.this.stroke;
                KeyStrokeEditor.this.stroke = null;
                KeyStrokeEditor.this.maybeStore(keyStroke);
            }
        });
    }

    private void maybeStore(KeyStroke keyStroke) {
        if (keyStroke != null && this.callback != null && this.validator.isValid(keyStroke)) {
            this.callback.set(keyStroke);
        }
    }

    @Override
    public void setValueInfo(Object object) {
        this.validator = object instanceof KeyStrokeValidator ? (KeyStrokeValidator)object : KeyStrokeValidator.EVERYTHING;
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public KeyStroke getValue() {
        return this.stroke;
    }

    @Override
    public void setCallback(PreferenceEditorCallback<KeyStroke> preferenceEditorCallback) {
        this.callback = preferenceEditorCallback;
        if (preferenceEditorCallback != null) {
            preferenceEditorCallback.setOperation(PreferenceOperation.DELETE, this.stroke != null);
        }
    }

    @Override
    public void setValue(KeyStroke keyStroke) {
        this.stroke = keyStroke;
        if (keyStroke == null) {
            if (this.focused) {
                this.setText("");
            } else {
                this.setText(DockUI.getDefaultDockUI().getString("preference.keystroke.click"));
            }
        } else if (this.validator.isValid(keyStroke)) {
            this.setText(KeyStrokeEditor.toString(keyStroke, true));
        } else {
            this.setText(KeyStrokeEditor.toString(keyStroke, !this.validator.isCompleteable(keyStroke)));
        }
        if (this.callback != null) {
            this.callback.setOperation(PreferenceOperation.DELETE, this.stroke != null);
        }
    }

    @Override
    public void doOperation(PreferenceOperation preferenceOperation) {
        if (preferenceOperation == PreferenceOperation.DELETE) {
            this.setValue(null);
            if (this.callback != null) {
                this.callback.set(null);
            }
        }
    }
}

