/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.preference;

import bibliothek.gui.dock.control.ModifierMask;
import bibliothek.util.xml.XElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface PreferenceFactory<V> {
    public static final PreferenceFactory<Boolean> FACTORY_BOOLEAN = new PreferenceFactory<Boolean>(){

        @Override
        public Boolean read(DataInputStream dataInputStream) throws IOException {
            return dataInputStream.readBoolean();
        }

        @Override
        public Boolean readXML(XElement xElement) {
            return xElement.getBoolean();
        }

        @Override
        public void write(Boolean bl, DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeBoolean(bl);
        }

        @Override
        public void writeXML(Boolean bl, XElement xElement) {
            xElement.setBoolean(bl);
        }
    };
    public static final PreferenceFactory<Integer> FACTORY_INT = new PreferenceFactory<Integer>(){

        @Override
        public Integer read(DataInputStream dataInputStream) throws IOException {
            return dataInputStream.readInt();
        }

        @Override
        public Integer readXML(XElement xElement) {
            return xElement.getInt();
        }

        @Override
        public void write(Integer n, DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeInt(n);
        }

        @Override
        public void writeXML(Integer n, XElement xElement) {
            xElement.setInt(n);
        }
    };
    public static final PreferenceFactory<String> FACTORY_STRING = new PreferenceFactory<String>(){

        @Override
        public String read(DataInputStream dataInputStream) throws IOException {
            return dataInputStream.readUTF();
        }

        @Override
        public String readXML(XElement xElement) {
            return xElement.getString();
        }

        @Override
        public void write(String string, DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeUTF(string);
        }

        @Override
        public void writeXML(String string, XElement xElement) {
            xElement.setString(string);
        }
    };
    public static final PreferenceFactory<KeyStroke> FACTORY_KEYSTROKE = new PreferenceFactory<KeyStroke>(){

        @Override
        public KeyStroke read(DataInputStream dataInputStream) throws IOException {
            return KeyStroke.getKeyStroke(dataInputStream.readUTF());
        }

        @Override
        public KeyStroke readXML(XElement xElement) {
            return KeyStroke.getKeyStroke(xElement.getString());
        }

        @Override
        public void write(KeyStroke keyStroke, DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeUTF(keyStroke.toString());
        }

        @Override
        public void writeXML(KeyStroke keyStroke, XElement xElement) {
            xElement.setString(keyStroke.toString());
        }
    };
    public static final PreferenceFactory<ModifierMask> FACTORY_MODIFIER_MASK = new PreferenceFactory<ModifierMask>(){

        @Override
        public ModifierMask read(DataInputStream dataInputStream) throws IOException {
            int n = dataInputStream.readInt();
            int n2 = dataInputStream.readInt();
            return new ModifierMask(n, n2);
        }

        @Override
        public ModifierMask readXML(XElement xElement) {
            int n = xElement.getInt("on");
            int n2 = xElement.getInt("off");
            return new ModifierMask(n, n2);
        }

        @Override
        public void write(ModifierMask modifierMask, DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeInt(modifierMask.getOnmask());
            dataOutputStream.writeInt(modifierMask.getOffmask());
        }

        @Override
        public void writeXML(ModifierMask modifierMask, XElement xElement) {
            xElement.addInt("on", modifierMask.getOnmask());
            xElement.addInt("off", modifierMask.getOffmask());
        }
    };

    public void write(V var1, DataOutputStream var2) throws IOException;

    public void writeXML(V var1, XElement var2);

    public V read(DataInputStream var1) throws IOException;

    public V readXML(XElement var1);
}

