% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenericFunctions.R,
%   R/spectralPreprocessing.R
\docType{methods}
\name{scatterCorrect}
\alias{scatterCorrect}
\alias{scatterCorrect,SpectraInTime-method}
\title{perform multiplicative scatter correction}
\usage{
scatterCorrect(object, ...)

\S4method{scatterCorrect}{SpectraInTime}(object, referenceSpectra = NULL, referenceMethod = "mean")
}
\arguments{
\item{object}{a S4 class object such as \code{\link{SpectraInTime-class}}}

\item{...}{for internal method consistency}

\item{referenceSpectra}{the reference spectra when not derived from the current data, defaults to \code{NULL} when \code{referenceMethod} is used 
to derive the reference spectra from the data}

\item{referenceMethod}{name of the function used to derive the spectra over the data measurements, defaults to \code{"mean"} when the average spectra in the 
\code{object} is used}
}
\value{
new S4 object with spectra scatter corrected

\code{\link{SpectraInTime-class}}
}
\description{
perform multiplicative scatter correction
}
\details{
multiplicative scatter correction consist of fitting regressing each spectra against the reference spectra and using the coefficients 
 of this regression model to correct for multiplicative light scatter by substracting the intercept and dividing by the slope
}
\examples{

 object1   <-  getSpectraInTimeExample()
 object2   <-  scatterCorrect( object1 )
 \donttest{
   plot( object1 )
   plot( object2 )
}
}
\author{
Adriaan Blommaert
}
\keyword{internal}
