% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outliermethods.R
\name{isoforest}
\alias{isoforest}
\title{Identify outliers using isolation forest model.}
\usage{
isoforest(
  data,
  size,
  cutoff = 0.5,
  output,
  exclude = NULL,
  pc = FALSE,
  boot = FALSE,
  pcvar = NULL,
  var
)
}
\arguments{
\item{data}{Dataframe of environmental variables extracted from where the species was recorded present or absent.}

\item{size}{Proportion of data to be used in training isolation forest n´model. It ranges form 0.1 (fewer data  selected ) to 1 to all data used in
training isolation model.}

\item{cutoff}{Cut to select where the record was an outlier or not.}

\item{output}{Either clean: for a data set with no outliers or outlier: to output a dataframe with outliers. Default is 0.5.}

\item{exclude}{Exclude variables that should not be considered in the fitting the one class model, for example x and y columns or
latitude/longitude or any column that the user doesn't want to consider.}

\item{pc}{Whether principal component analysis will be computed. Default \code{FALSE}}

\item{boot}{Whether bootstrapping will be computed. Default \code{FALSE}}

\item{pcvar}{Principal component analysis to e used for outlier detection after PCA. Default \code{PC1}}

\item{var}{The variable of concern, which is vital for univariate outlier detection methods}
}
\value{
Dataframe with or with no outliers.
}
\description{
Identify outliers using isolation forest model.
}
\examples{

\donttest{

data("efidata")
danube <- system.file('extdata/danube.shp.zip', package='specleanr')

db <- sf::st_read(danube, quiet=TRUE)

wcd <- terra::rast(system.file('extdata/worldclim.tiff', package='specleanr'))

refdata <- pred_extract(data = efidata, raster= wcd ,
                       lat = 'decimalLatitude',
                       lon= 'decimalLongitude',
                       colsp = "scientificName",
                      bbox = db,
                       minpts = 10)

iosd <- isoforest(data = refdata[["Thymallus thymallus"]], size = 0.7,  output='outlier',
                  exclude = c("x", "y"))
}

}
\references{
\enumerate{
\item Liu FeiT, Ting KaiM, Zhou Z-H. 2008. Isolation Forest. Pages 413–422 In 2008 Eighth IEEE International Conference on Data Mining.
Available from https://ieeexplore.ieee.org/abstract/document/4781136 (accessed November 18, 2023).
}
}
