% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec.R
\name{respecify.spec}
\alias{respecify.spec}
\title{Respecify Specification}
\usage{
\method{respecify}{spec}(x, data, file = NULL, ...)
}
\arguments{
\item{x}{spec}

\item{data}{a data.frame or path to csv file}

\item{file}{where to write the result (default: do not write)}

\item{...}{passed arguments}
}
\description{
Respecify specification. Updates numeric ranges.  Useful if these have changed and spec no longer matches.
}
\examples{
data(drug)
file <- tempfile()
spec <- specification(drug,tol = 3)
write.spec(spec, file = file)
drug \\\%matches\\\% spec
drug \\\%matches\\\% file
max <- max(drug$DV,na.rm=TRUE)
drug$DV[!is.na(drug$DV) & drug$DV == max] <- max + 1
drug \\\%matches\\\% file
respecify(file, drug)
drug \\\%matches\\\% file
}
