% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{normal}
\alias{normal}
\alias{normal_p}
\alias{lognormal}
\alias{lognormal_p}
\alias{triangular}
\alias{triangular_p}
\alias{uniform}
\alias{uniform_p}
\title{Evaluating a distribution}
\usage{
normal(mu, sigma)

normal_p(mu, sigma)

lognormal(mu, sigma)

lognormal_p(mu, sigma)

triangular(mu, sigma)

triangular_p(mu, sigma)

uniform(mu, sigma)

uniform_p(mu, sigma)
}
\arguments{
\item{mu}{A parameter indicating the mean or location of the distribution
depending on whether it is a normal, log-normal, triangular or uniform,
or it can be another call to \code{\link{normal}}, \code{\link{lognormal}},
\code{\link{uniform}} or \code{\link{triangular}} if the model is an RPL with
a Bayesian prior.}

\item{sigma}{A parameter indicating the SD or spread of the distribution
or it can be another call to \code{\link{normal}}, \code{\link{lognormal}},
 \code{\link{uniform}} or \code{\link{triangular}}.}
}
\value{
A list of parameters
}
\description{
The function returns its arguments as a named list. The function is used
inside the utility functions. It is transformed to an expression using
\code{\link{parse}} and evaluated using \code{\link{eval}}. This ensures
that in the case of an RPL with Bayesian priors, recursion is handled
automatically. This significantly simplifies translating the utility function
to lists of parameters to use when optimizing the designs. It is also less
error prone.
}
\section{Functions}{
\itemize{
\item \code{normal()}: The normal distribution

\item \code{normal_p()}: The normal distribution when applied to a prior

\item \code{lognormal()}: The log normal distribution

\item \code{lognormal_p()}: The log-normal distribution when applied to a prior

\item \code{triangular()}: The triangular distribution

\item \code{triangular_p()}: The triangular distribution when applied to a prior

\item \code{uniform()}: The uniform distribution

\item \code{uniform_p()}: The uniform distribution when applied to a prior

}}
