\name{subfits}
\alias{subfits}
\alias{subfits.new}
\alias{subfits.old}
\title{Extract List of Individual Point Process Models}
\description{
  Takes a Gibbs point process model that has been fitted
  to several point patterns simultaneously, and produces a list
  of fitted point process models for the individual point patterns.
}
\usage{
   subfits(object, what="models", verbose=FALSE)
   subfits.old(object, what="models", verbose=FALSE)
   subfits.new(object, what="models", verbose=FALSE)
}
\arguments{
  \item{object}{
    An object of class \code{"mppm"}
    representing a point process model fitted to several point patterns. 
  }
  \item{what}{
    What should be returned.
    Either \code{"models"} to return the fitted models,
    or \code{"interactions"} to return the fitted interactions only.
  }
  \item{verbose}{
    Logical flag indicating whether to print progress reports.
  }
}
\details{
  \code{object} is assumed to have been generated by
  \code{\link{mppm}}. It represents a point process model that has been
  fitted to a list of several point patterns, with covariate data.

  For each of the \emph{individual} point pattern
  datasets, this function derives the corresponding fitted model
  for that dataset only (i.e. a point process model for the \eqn{i}th
  point pattern, that is consistent with \code{object}). 

  If \code{what="models"},
  the result is a list of point process models (a list of objects of class
  \code{"ppm"}), one model for each point pattern dataset in the
  original fit.
  If \code{what="interactions"},
  the result is a list of fitted interpoint interactions (a list of
  objects of class
  \code{"fii"}).

  Two different algorithms are provided, as
  \code{subfits.old} and \code{subfits.new}.
  Currently \code{subfits} is the same as the old algorithm
  \code{subfits.old} because the newer algorithm is too memory-hungry.
}
\value{
  A list of point process models (a list of objects of class
  \code{"ppm"}) or a list of fitted interpoint interactions (a list of
  objects of class \code{"fii"}).
}
\examples{
  H <- hyperframe(Wat=waterstriders)
  fit <- mppm(Wat~x, data=H)
  subfits(fit)

  H$Wat[[3]] <- rthin(H$Wat[[3]], 0.1)
  fit2 <- mppm(Wat~x, data=H, random=~1|id)
  subfits(fit2)
}
\references{
  Baddeley, A., Rubak, E. and Turner, R. (2015)
  \emph{Spatial Point Patterns: Methodology and Applications with R}.
  London: Chapman and Hall/CRC Press. 
}
\author{
  Adrian Baddeley, Ida-Maria Sintorn and Leanne Bischoff.
  Implemented in \pkg{spatstat} by
  Adrian Baddeley \email{Adrian.Baddeley@curtin.edu.au},
 Rolf Turner \email{r.turner@auckland.ac.nz}
 and Ege Rubak \email{rubak@math.aau.dk}.
}
\seealso{
  \code{\link{mppm}},
  \code{\link{ppm}}
}
\keyword{spatial}
\keyword{models}

