\name{demohyper}
\alias{demohyper}
\docType{data}
\title{
  Demonstration Example of Hyperframe of Spatial Data
}
\description{
  This is an artificially constructed example of a
  hyperframe of spatial data. The data could have been obtained
  from an experiment in which there are two groups of
  experimental units, the response from each unit
  is a point pattern \code{Points}, and for each unit there is explanatory
  data in the form of a pixel image \code{Image}.
}
\usage{data(demohyper)}
\format{
  A \code{\link[spatstat]{hyperframe}} with 3 rows and 3 columns:
  \describe{
    \item{Points}{
      List of spatial point patterns
      (objects of class \code{"ppp"})
      serving as the responses in an experiment.
    }
    \item{Image}{
      List of images (objects of class \code{"im"})
      serving as explanatory variables.
    }
    \item{Group}{
      Factor with two levels \code{a} and \code{b}
      serving as an explanatory variable.
    }
  }
}
\source{
  Artificially generated by \adrian.
}
\examples{
  if(require(spatstat)) {
 plot(demohyper, quote({ plot(Image, main=""); plot(Points, add=TRUE) }),
      parargs=list(mar=rep(1,4)))
 mppm(Points ~ Group/Image, data=demohyper)
  }
}
\keyword{datasets}
