% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_times.R
\name{group_times}
\alias{group_times}
\title{Group Times}
\usage{
group_times(DT = NULL, datetime = NULL, threshold = NULL)
}
\arguments{
\item{DT}{input data.table}

\item{datetime}{name of time column(s). either 1 POSIXct or 2 IDate and ITime. eg: 'datetime' or c('IDate', 'ITime')}

\item{threshold}{threshold for grouping times. eg: '2 hours', '10 minutes', etc. if not provided, times will be matched exactly. Note that provided threshold must be in the expected format: '## unit'}
}
\description{
Assign an integer timegroup.
Provide the threshold to group on and rows will be grouped.
If the threshold is NULL, rows are grouped by matching exact datetimes.
}
\details{
The threshold can be in units of minutes, hours or days.
}
\examples{
library(data.table)
DT <- fread(system.file("extdata", "DT.csv", package = "spatsoc"))
DT[, datetime := as.POSIXct(datetime,
                            tz = 'UTC')]

group_times(DT, datetime = 'datetime', threshold = '5 minutes')

group_times(DT, datetime = 'datetime', threshold = '2 hours')

group_times(DT, datetime = 'datetime', threshold = '10 days')

}
