% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatialwarnings.R
\docType{package}
\name{spatialwarnings}
\alias{spatialwarnings}
\alias{spatialwarnings-package}
\title{Early Spatial-Warnings of Ecosystem Degradation}
\description{
Many dynamical systems such as ecosystems exhibit non-linear responses to 
changes in their external drivers, resulting in possible wide state shifts 
with strong ecological or economical consequences. This often happens when 
a system exhibit a change in its stability properties as a threshold is 
crossed, \emph{e.g.} going from multiple stable states to a single stable 
state. For a few decades, much research has been dedicated to finding a 
way to anticipate these tipping points in ecological systems. This has led 
to the development of several indicators, i.e. metrics based on spatial
structure, that could reflect the proximity of an ecosystem to a tipping
point. 

This package implements the computation of these indicators, or 
\emph{early-warning signals} (EWS), on spatial raster data. High-level 
functions and methods provide familiar workflows to compute the indicators 
and display their variations along environmental gradients or time-series. 
Lower-level functions are also available to integrate early-warning signals 
into different workflows. 

Main functions provided by this package: 

"Workflow" functions, which may compute several indicators at once:
\itemize{ 
  \item \code{\link{generic_sews}}: Generic spatial EWS
  \item \code{\link{spectral_sews}}: Spectrum-based EWS
  \item \code{\link{patchdistr_sews}}: EWS based on patch-size distributions
  \item \code{\link{kbdm_sews}}: Kolmogorov complexity
  \item \code{\link{flowlength_sews}}: Flow length 
  \item \code{\link{variogram_sews}}: Variogram-based indicators
}

Individual indicators, which may be used to compute raw indicator values 
  on a single matrix: 

\itemize{ 
  \item \code{\link{raw_cg_moran}}: lag-1 spatial autocorrelation 
  \item \code{\link{raw_cg_variance}}: Spatial variance
  \item \code{\link{raw_cg_skewness}}: Spatial skewness
  \item \code{\link{raw_sdr}}: Spectral density ratio (SDR)
  \item \code{\link{indicator_psdtype}}: Patch-size distribution shape 
  \item \code{\link{indicator_plrange}}, 
          \code{\link{raw_plrange}} : Power-law range
  \item \code{\link{raw_kbdm}}: Kolmogorov complexity
  \item \code{\link{raw_flowlength_uniform}}: Flow Length
  \item \code{\link{raw_variogram_metrics}}: Variogram-based metrics
}

The package homepage is available at 
\href{https://github.com/spatial-ews/spatialwarnings}{Github}
and a  
\href{https://alex.lecairn.org/spatialwarnings-faq.html}{user guide} is 
also available.
}
