% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/squareBuffer.R
\name{squareBuffer}
\alias{squareBuffer}
\title{Square buffer}
\usage{
squareBuffer(x, a, ...)
}
\arguments{
\item{x}{An sf object}

\item{a}{Numeric single or vector indicating buffer distance(s)}

\item{...}{Additional arguments passed to st_buffer}
}
\value{
A single feature sf class polygon object
}
\description{
Creates a square buffer of a feature class
}
\details{
Function creates a square buffer of feature class.
}
\examples{
library(sf)
xy <- st_as_sf(data.frame(x = c(1,3,6,7),
               y = c(3,2,7,8), z = c(38,23,12,12),
               area = c(32,23,45,67)),
			      coords = c("x", "y"), 
			      agr = "constant") 

# With fixed buffer
sb <- squareBuffer(xy, 32)
  plot(st_geometry(sb))
    plot(st_geometry(xy), pch=20, add=TRUE)
  
# With variable buffer
sb.var <- squareBuffer(xy, xy$area)
  plot(st_geometry(sb.var))
    plot(st_geometry(xy), pch=20, add=TRUE)
  
}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
