% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_vertices.R
\name{extract.vertices}
\alias{extract.vertices}
\title{Extract vertices for polygons or lines}
\usage{
extract.vertices(x, as.sp = FALSE, rm.duplicates = FALSE, join = FALSE)
}
\arguments{
\item{x}{An sp class SpatialPolygonsDataFrame, SpatialPolygons,
SpatialLinesDataFrame or SpatialLines object}

\item{as.sp}{(FALSE/TRUE) Output as sp SpatialPointsDataFrame}

\item{rm.duplicates}{(FALSE/TRUE) remove duplicate (x,y) coordinates}

\item{join}{(FALSE/TRUE) Joint attributes from original object}
}
\value{
A SpatialPointsDataFrame or data.frame with id, x, y and merged attributes
}
\description{
Extracts [x,y] vertices from an sp line or polygon object
}
\note{
This function returns the vertices of a line or polygon object, as opposed
to the polygon centroids or line start/stop coordinates available in 
the @coords slot. This requires accessing the coordinates located in the 
x@polygons@Polygons or x@lines@Lines slots
}
\examples{
library(sp)
library(raster)
library(sf)

# For polygons
r <- raster(xmn=-11.69, xmx=2988.31, ymn=-749.97, ymx=1650.03,
            resolution=c(100,100))
  r[] <- runif(ncell(r))
    names(r) <- "random_process"
  
polys <- as(r, "SpatialPolygonsDataFrame")
  polys <- polys[sample(1:nrow(polys),10),]

extract.vertices(polys, join=TRUE, rm.duplicates=TRUE)

v <- extract.vertices(polys, as.sp=TRUE, join=TRUE)
  head(v@data)
  
  plot(polys)
    points(v, pch=20, cex=2, col="red")

# For lines
nc <- sf::st_read(system.file("shape/nc.shp", package="sf"))
  nc <- sf::st_cast(sf::st_cast(nc, "POLYGON"), "LINESTRING")
    nc <- as(nc, "Spatial")
 
extract.vertices(nc)
extract.vertices(nc, join=TRUE, rm.duplicates=TRUE)

v <- extract.vertices(nc, as.sp=TRUE, join=TRUE)
  head(v@data)

  plot(nc)
    points(v, pch=20, cex=2, col="red")

}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
