% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gbm.R, R/lorenz.R
\name{lorenz}
\alias{lorenz}
\alias{gbm}
\title{Geometric Brownian motion spatPomp simulator}
\usage{
gbm(U = 5, N = 100, delta_t = 0.1, IVP_values = 1, delta_obs = 1)

lorenz(
  U = 5,
  N = 100,
  delta_t = 0.01,
  delta_obs = 0.5,
  regular_params = c(F = 8, sigma = 1, tau = 1)
)
}
\arguments{
\item{U}{A length-one numeric signifying the number of spatial units for the process.}

\item{N}{A length-one numeric signifying the number of observations.}

\item{delta_t}{A length-one numeric giving the Euler time step for the numerical solution.}

\item{IVP_values}{initial value parameters for the latent states}

\item{delta_obs}{A length-one numeric giving the time between observations.}

\item{regular_params}{A named numeric vector containing the values of the \code{F},
\code{sigma} and \code{tau} parameters.
\code{F=8} is a common value that causes chaotic behavior.}
}
\value{
An object of class \sQuote{spatPomp} representing a simulation from a \code{U}-dimensional
geometric Brownian motion

An object of class \sQuote{spatPomp} representing a simulation from a \code{U}-dimensional
Lorenz 96 model
}
\description{
Generate a spatPomp object representing a \code{U}-dimensional
geometric Brownian motion with spatial correlation decaying geometrically with
distance around a circle. The model is defined in continuous time, but
an Euler approximation is used for this numerical implementation.

Generate a spatPomp object representing a \code{U}-dimensional stochastic Lorenz '96 process with
\code{N} measurements made at times \eqn{t_n = n * delta_obs}, simulated using an Euler method
with time increment \code{delta_t}.
}
\examples{
# Complete examples are provided in the package tests
\dontrun{
g <- gbm(U=4, N=20)
# See all the model specifications of the object
spy(g)
}

# Complete examples are provided in the package tests
\dontrun{
l <- lorenz(U=5, N=100, delta_t=0.01, delta_obs=1)
# See all the model specifications of the object
spy(l)
}
}
\references{
\asfaw2021thesis

\lorenz96

\ionides2021
}
\seealso{
Other spatPomp examples: 
\code{\link{bm}()},
\code{\link{he10}()},
\code{\link{measles}()}

Other spatPomp examples: 
\code{\link{bm}()},
\code{\link{he10}()},
\code{\link{measles}()}
}
\author{
Kidus Asfaw

Edward L. Ionides
}
\concept{spatPomp examples}
