% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bm2.R
\name{bm2}
\alias{bm2}
\title{Brownian motion spatPomp generator with shared or unit-specific parameters}
\usage{
bm2(
  U = 5,
  N = 100,
  delta_t = 0.1,
  unit_specific_names = "rho",
  shared_names = NULL,
  unit_params = c(rho = 0.4, sigma = 1, tau = 1, X_0 = 0)
)
}
\arguments{
\item{U}{A length-one numeric signifying dimension of the process.}

\item{N}{A length-one numeric signifying the number of observation time steps to evolve the process.}

\item{delta_t}{Process simulations are performed every \code{delta_t} time units
whereas observations occur every one time unit}

\item{unit_specific_names}{determines which parameters take a different value
for each unit. Cannot be specified if shared_names is specified.
each unit. Other parameters are considered shared between all units.}

\item{shared_names}{identifies parameters that have common shared value for all units, which by default is all parameters.}

\item{unit_params}{parameter values used to build the object, copied across 
each unit for unit-specific parameters}
}
\value{
An object of class \sQuote{spatPomp} representing a simulation from a
\code{U}-dimensional Brownian motion
}
\description{
An extension of \code{bm} allowing for shared or unit-specific parameters.
Generate a class \sQuote{spatPomp} object representing a \code{U}-dimensional
Brownian motion with spatial correlation decaying geometrically with
distance around a circle. The model is defined in continuous time
though in this case an Euler approximation is exact at the evaluation
times.
}
\examples{
# Complete examples are provided in the package tests
\dontrun{
b <- bm2(U=4, N=20,shared_names="rho",unit_specific_names=c("sigma","tau"))
# See all the model specifications of the object
spy(b)
# Examples of methodologies applied to this model
# are provided in the tests directory
}
}
\author{
Edward L. Ionides
}
