% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/efast_sampling.R
\name{efast_generate_sample}
\alias{efast_generate_sample}
\title{Generates parameter sets for variance-based eFAST Sensitivity Analysis}
\usage{
efast_generate_sample(FILEPATH, NUMCURVES, NUMSAMPLES, PARAMETERS, PMIN, PMAX)
}
\arguments{
\item{FILEPATH}{Directory where the parameter samples should be output to}

\item{NUMCURVES}{The number of 'resamples' to perform (see eFAST
documentation) - recommend using at least 3}

\item{NUMSAMPLES}{The number of parameter subsets to generate - should be at
least 65 for eFAST}

\item{PARAMETERS}{Array containing the names of the parameters of which
parameter samples will be generated.  For eFAST, remember to add a
parameter named 'Dummy'}

\item{PMIN}{Array containing the minimum value that should be used for each
parameter and the dummy. Sets a lower bound on sampling space}

\item{PMAX}{Array containing the maximum value that should be used for each
parameter and the dummy. Sets an upper bound on sampling space}
}
\description{
This technique analyses simulation results generated through sampling
using the eFAST approach (extended Fourier Amplitude Sampling Test).
This perturbs the value of all parameters at the same time, with the
aim of partitioning the variance in simulation output between input
parameters. Values for each parameter are chosen using fourier frequency
curves through a parameters potential range of values. A selected
number of values are selected from points along the curve. Though all
parameters are perturbed simultaneously, the method does focus on
one parameter of interest in turn, by giving this a very different
sampling frequency to that assigned to the other parameters.
Thus for each parameter of interest in turn, a sampling frequency is
assigned to each parameter and values chosen at points along the curve. So
a set of simulation parameters then exists for each parameter of interest.
As this is the case, this method can be computationally expensive,
especially if a large number of samples is taken on the parameter search
curve, or there are a large number of parameters. On top of this, to ensure
adequate sampling each curve is also resampled with a small adjustment to the
frequency, creating more parameter sets on which the simulation should be run.
This attempts to limit any correlations and limit the effect of repeated
parameter value sets being chosen. Samples are output to CSV file, one per
parameter/curve pairing
}
