efast_parameterdist <-
function(PARAMVALS,PMAX,PMIN,NUMSAMPLES,NUMPARAMS)
{	
	# NOTE NO CHANGE IN TYPE HAS BEEN IMPLEMENTED HERE - ASSUMES UNIFORM DISTRIBUTION IS REQUIRED
	# SALTELLI ET AL's MATLAB CODE DOES HOWEVER ALLOW FOR NORMAL OR LOGNORMAL DISTRIBUTIONS	
	# LOOP THROUGH THE PARAMETERS
   	for(PARAM in 1:NUMPARAMS)
	{
		nvar<-length(PMIN)
		ran <- array(runif(NUMSAMPLES,min=0,max=1),dim=c(NUMSAMPLES,1,1))
		zer <- array(0,dim=c(NUMSAMPLES,1,1))
		idx <- sample(NUMSAMPLES)
		P =(idx-ran)/NUMSAMPLES

		# NOW MULTIPLY THE VALUE THAT IS BETWEEN 0 AND 1 BY SUM OF PARAM (MAX-MIN)+MIN TO GET TRUE PARAM VALUE
		PARAMVALS[,PARAM] <- PARAMVALS[,PARAM]*(PMAX[PARAM]-PMIN[PARAM])+PMIN[PARAM]
	}

	return(PARAMVALS)
}

