% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_converters.R
\name{as_sparta}
\alias{as_sparta}
\alias{as_sparta.array}
\alias{as_sparta.matrix}
\alias{as_sparta.table}
\alias{as_sparta.sparta}
\alias{as_sparta.data.frame}
\title{As sparse table}
\usage{
as_sparta(x)

\method{as_sparta}{array}(x)

\method{as_sparta}{matrix}(x)

\method{as_sparta}{table}(x)

\method{as_sparta}{sparta}(x)

\method{as_sparta}{data.frame}(x)
}
\arguments{
\item{x}{array-like object or a data.frame}
}
\value{
A sparta object
}
\description{
Turn an array-like object or a data.frame into a sparse representation
}
\examples{

# ----------
# Example 1)
# ----------

x <- array(
  c(1,0,0,2,3,4,0,0),
  dim = c(2,2,2),
  dimnames = list(
    a = c("a1", "a2"),
    b = c("b1", "b2"),
    c = c("c1", "c2")
  )
)

as_sparta(x)

# ----------
# Example 2)
# ----------

y   <- mtcars[, c("gear", "carb")]
y[] <- lapply(y, as.character)
as_sparta(y)

}
\seealso{
\code{\link{as_array}}
}
