% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparsebnUtils-options.R
\name{resetGraphPackage}
\alias{getGraphPackage}
\alias{resetGraphPackage}
\alias{setGraphPackage}
\title{Change data structure for representing graphs internally}
\usage{
resetGraphPackage(coerce = TRUE)

setGraphPackage(pkg, matchPlot = TRUE, coerce = FALSE)

getGraphPackage()
}
\arguments{
\item{coerce}{If \code{TRUE}, then all \code{\link{sparsebnFit}} and \code{\link{sparsebnPath}} objects in the global environment will be coerced to be compatible with the selected package. This will overwrite your existing data.}

\item{pkg}{The desired package; default value is \code{NULL} corresponding to \link{edgeList}. Possible values are \code{"sparsebn"}, \code{"igraph"}, \code{"graph"}, \code{"bnlearn"}, and \code{"network"}.}

\item{matchPlot}{Force the underlying plotting mechanism to match the selected package (see \link{setPlotPackage}).}
}
\description{
Changes the output of the main algorithms to be compatible with other packages in the R ecosystem.
}
\details{
\code{sparsebn} is compatible with four different data structures for representing graphs:
\link{edgeList} (default), \link[graph]{graphNEL-class} (from the \code{graph} package),
\link[igraph]{igraph} (from the \link[igraph]{igraph} package), and \link[network]{network} (from
\link[network]{network-package}). \link{edgeList} is provided by default in \code{sparsebn}, however,
the other three options require that extra packages are installed.
}
\section{Functions}{
\itemize{
\item \code{resetGraphPackage}: Reset all data to default \code{\link{edgeList}} format and set graph package back to default \code{"sparsebn"}.

\item \code{getGraphPackage}: Returns the current choice of graph package ( \code{NULL} corresponds to no selection)
}}
\seealso{
\code{\link{setPlotPackage}}, \code{\link{getPlotPackage}}
}

