% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sdf_interface.R
\name{sdf_quantile}
\alias{sdf_quantile}
\title{Compute (Approximate) Quantiles with a Spark DataFrame}
\usage{
sdf_quantile(x, column, probabilities = c(0, 0.25, 0.5, 0.75, 1),
  relative.error = 1e-05)
}
\arguments{
\item{x}{A \code{spark_connection}, \code{ml_pipeline}, or a \code{tbl_spark}.}

\item{column}{The column for which quantiles should be computed.}

\item{probabilities}{A numeric vector of probabilities, for
which quantiles should be computed.}

\item{relative.error}{The relative error -- lower values imply more
precision in the computed quantiles.}
}
\description{
Given a numeric column within a Spark DataFrame, compute
approximate quantiles (to some relative error).
}
