% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spark_apply.R
\name{spark_apply}
\alias{spark_apply}
\title{Apply an R Function in Spark}
\usage{
spark_apply(x, f, names = colnames(x), memory = TRUE, group_by = NULL,
  packages = TRUE, ...)
}
\arguments{
\item{x}{An object (usually a \code{spark_tbl}) coercable to a Spark DataFrame.}

\item{f}{A function that transforms a data frame partition into a data frame.}

\item{names}{The column names for the transformed object, defaults to the
names from the original object.}

\item{memory}{Boolean; should the table be cached into memory?}

\item{group_by}{Column name used to group by data frame partitions.}

\item{packages}{Boolean; distribute \code{.libPaths()} packages to nodes?}

\item{...}{Optional arguments; currently unused.}
}
\description{
Applies an R function to a Spark object (typically, a Spark DataFrame).
}
