% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarizers.R
\name{summarize_z_score}
\alias{summarize_z_score}
\title{Z-score summarizer}
\usage{
summarize_z_score(
  ts_rdd,
  column,
  include_current_observation = FALSE,
  key_columns = list()
)
}
\arguments{
\item{ts_rdd}{Timeseries RDD being summarized}

\item{column}{Column to be summarized}

\item{include_current_observation}{If true, then use unbiased sample standard
deviation with current observation in z-score calculation, otherwise use
unbiased sample standard deviation excluding current observation}

\item{key_columns}{Optional list of columns that will form an equivalence
relation associating each row with the time series it belongs to (i.e., any
2 rows having equal values in those columns will be associated with the
same time series, and any 2 rows having differing values in those columns
are considered to be from 2 separate time series and will therefore be
summarized separately)
By default, `key_colums` is empty and all rows are considered to be part of
a single time series.}
}
\value{
A TimeSeriesRDD containing the summarized result
}
\description{
Compute z-score of the most recent value in the column specified, with
respect to the sample mean and standard deviation observed so far, with the
option for out-of-sample calculation, and store result in a new column named
`<column>_zScore`
}
\examples{

library(sparklyr)
library(sparklyr.flint)

sc <- try_spark_connect(master = "local")

if (!is.null(sc)) {
  sdf <- copy_to(sc, tibble::tibble(t = seq(10), v = rnorm(10)))
  ts <- fromSDF(sdf, is_sorted = TRUE, time_unit = "SECONDS", time_column = "t")
  ts_z_score <- summarize_z_score(ts, column = "v", include_current_observation = TRUE)
} else {
  message("Unable to establish a Spark connection!")
}

}
\seealso{
Other summarizers: 
\code{\link{summarize_avg}()},
\code{\link{summarize_corr2}()},
\code{\link{summarize_corr}()},
\code{\link{summarize_count}()},
\code{\link{summarize_covar}()},
\code{\link{summarize_dot_product}()},
\code{\link{summarize_max}()},
\code{\link{summarize_min}()},
\code{\link{summarize_nth_central_moment}()},
\code{\link{summarize_nth_moment}()},
\code{\link{summarize_product}()},
\code{\link{summarize_quantile}()},
\code{\link{summarize_stddev}()},
\code{\link{summarize_sum}()},
\code{\link{summarize_var}()},
\code{\link{summarize_weighted_avg}()},
\code{\link{summarize_weighted_corr}()},
\code{\link{summarize_weighted_covar}()}
}
\concept{summarizers}
