% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sdf_utils.R
\name{fromSDF}
\alias{fromSDF}
\title{Construct a TimeSeriesRDD from a Spark DataFrame}
\usage{
fromSDF(
  sdf,
  is_sorted = FALSE,
  time_unit = .sparklyr.flint.globals$kValidTimeUnits,
  time_column = .sparklyr.flint.globals$kDefaultTimeColumn
)
}
\arguments{
\item{sdf}{A Spark DataFrame object}

\item{is_sorted}{Whether the rows being imported are already sorted by time}

\item{time_unit}{Time unit of the time column (must be one of the following
values: "NANOSECONDS", "MICROSECONDS", "MILLISECONDS", "SECONDS",
"MINUTES", "HOURS", "DAYS"}

\item{time_column}{Name of the time column}
}
\value{
A TimeSeriesRDD useable by the Flint time series library
}
\description{
Construct a TimeSeriesRDD containing time series data from a Spark DataFrame
}
\examples{

library(sparklyr)
library(sparklyr.flint)

sc <- try_spark_connect(master = "local")

if (!is.null(sc)) {
  sdf <- copy_to(sc, tibble::tibble(t = seq(10), v = seq(10)))
  ts <- fromSDF(sdf, is_sorted = TRUE, time_unit = "SECONDS", time_column = "t")
} else {
  message("Unable to establish a Spark connection!")
}

}
