% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmrs.R
\name{mr_data2bids}
\alias{mr_data2bids}
\title{Create a BIDS file structure from a vector of data paths or list of
mri/mrs data objects.}
\usage{
mr_data2bids(
  mr_data,
  suffix,
  output_dir,
  sub = NULL,
  ses = NULL,
  task = NULL,
  acq = NULL,
  nuc = NULL,
  voi = NULL,
  rec = NULL,
  run = NULL,
  echo = NULL,
  inv = NULL,
  skip_existing = TRUE,
  mri_format = "nifti",
  deface_mri = FALSE
)
}
\arguments{
\item{mr_data}{vector of data paths or list of mri/mrs objects.}

\item{suffix}{vector of file suffixes, eg : c("svs", "mrsi", "T1w).}

\item{output_dir}{the base directory to create the BIDS structure.}

\item{sub}{optional vector of subject labels. If not specified, these will be
automatically generated as a series of increasing zero-padded integer values
corresponding to the mrs_data input indices.}

\item{ses}{optional vector of session labels.}

\item{task}{optional vector of task labels.}

\item{acq}{optional vector of acquisition labels.}

\item{nuc}{optional vector of nucleus labels.}

\item{voi}{optional vector of volume of interest labels.}

\item{rec}{optional vector of reconstruction labels.}

\item{run}{optional vector of run indices.}

\item{echo}{optional vector of echo time indices.}

\item{inv}{optional vector of inversion indices.}

\item{skip_existing}{skip any data files that have already been converted.
Defaults to TRUE, set to FALSE to force an overwrite of any existing data
files.}

\item{mri_format}{defaults to "nifti", can also be "dicom" provided the
divest packages is installed.}

\item{deface_mri}{option to apply fsl_deface to the mri as a preprocessing
step. Defaults to FALSE, requires the fslr package to be installed when TRUE.}
}
\description{
Create a BIDS file structure from a vector of data paths or list of
mri/mrs data objects.
}
