% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrs_data_proc.R
\name{comb_coils_svs_gls}
\alias{comb_coils_svs_gls}
\title{Combine SVS coil data using the GLS method presented by An et al
JMRI 37:1445-1450 (2013).}
\usage{
comb_coils_svs_gls(
  metab,
  ref = NULL,
  noise_pts = 256,
  noise_mrs = NULL,
  use_mean_sens = TRUE
)
}
\arguments{
\item{metab}{MRS data containing metabolite data.}

\item{ref}{MRS data containing reference data (optional).}

\item{noise_pts}{number of points from the end of the FIDs to use for noise
covariance estimation.}

\item{noise_mrs}{MRS data containing noise information for each coil.}

\item{use_mean_sens}{use the dynamic mean to estimate coil sensitivities.}
}
\value{
coil combined MRS data.
}
\description{
Combine SVS coil data using the GLS method presented by An et al
JMRI 37:1445-1450 (2013).
}
