% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varpro.R
\name{varpro_opts}
\alias{varpro_opts}
\title{Return a list of options for VARPRO based fitting.}
\usage{
varpro_opts(
  nstart = 20,
  init_g_damping = 2,
  maxiters = 200,
  max_shift = 5,
  max_g_damping = 5,
  max_ind_damping = 5,
  anal_jac = TRUE,
  bl_smth_pts = 80
)
}
\arguments{
\item{nstart}{position in the time-domain to start fitting, units of data
points.}

\item{init_g_damping}{starting value for the global Gaussian line-broadening
term - measured in Hz.}

\item{maxiters}{maximum number of levmar iterations to perform.}

\item{max_shift}{maximum shift allowed to each element in the basis set,
measured in Hz.}

\item{max_g_damping}{maximum permitted global Gaussian line-broadening.}

\item{max_ind_damping}{maximum permitted Lorentzian line-broadening for each
element in the basis set, measured in Hz.}

\item{anal_jac}{option to use the analytic or numerical Jacobian (logical).}

\item{bl_smth_pts}{number of data points to use in the baseline smoothing
calculation.}
}
\value{
list of options.
}
\description{
Return a list of options for VARPRO based fitting.
}
\examples{
varpro_opts(nstart = 10)
}
