% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal-utils.R
\name{spod_get_valid_dates}
\alias{spod_get_valid_dates}
\title{Get valid dates for the specified data version}
\usage{
spod_get_valid_dates(ver = NULL)
}
\arguments{
\item{ver}{Integer. Can be 1 or 2. The version of the data to use. v1 spans 2020-2021, v2 covers 2022 and onwards. See more details in codebooks with \code{\link[=spod_codebook]{spod_codebook()}}.}
}
\value{
A vector of type \code{Date} with all possible valid dates for the specified data version (v1 for 2020-2021 and v2 for 2020 onwards).
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Get all metadata for requested data version and identify all dates available for download.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
# Get all valid dates for v1 (2020-2021) data
spod_get_valid_dates(ver = 1)

# Get all valid dates for v2 (2020 onwards) data
spod_get_valid_dates(ver = 2)
}
\dontshow{\}) # examplesIf}
}
