% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetSim.R
\name{plot.NetSim}
\alias{plot.NetSim}
\title{Plot a simulated network from a NetSim object}
\usage{
\method{plot}{NetSim}(
  x,
  y,
  ...,
  layout = "stress",
  title = "Network Simulation",
  node_color = "red",
  edge_color = "blue"
)
}
\arguments{
\item{x}{a NetSim graph}

\item{y}{ignored.}

\item{...}{ignored.}

\item{layout}{a layout to display the graph. Layout must be a valid string.
from the ggraph package. Default is "stress".}

\item{title}{an optional title.}

\item{node_color}{a color for the nodes. Default is blue.}

\item{edge_color}{a color for the edges. Default is red.}
}
\value{
A plot of classes 'ggraph' 'gg' and 'ggplot'
}
\description{
This can take either a PowerLawNetwork or APLNetwork object as
input, both of which are chidren of the NetSim class.
}
\details{
This method returns a ggraph object, which can be further refined
using standard ggraph and ggplot facilities.
}
\examples{
# Load spacejamr object
data("RI")

ri_points <- PointSim(points = 10, window = RI, seed = 42)
spl_points <- NetSim(ri_points, base_prob = 0.92, scale = 1, threshold = 0.5,
                     power = -2.4)
plot(spl_points)

}
\author{
Darren Colby \cr
Email:dscolby17@gmail.com
}
