% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_functions.R
\name{build_graph_directed}
\alias{build_graph_directed}
\title{Directed network generation}
\usage{
build_graph_directed(lines, digits, line_weight, direction, attrs = FALSE)
}
\arguments{
\item{lines}{A SpatialLinesDataFrame}

\item{digits}{The number of digits to keep from the coordinates}

\item{line_weight}{The name of a field that represent the cost to use a line}

\item{direction}{A vector of integers. 0 indicates a bidirectional line and 1
an unidirectional line must be added to the graph lines}

\item{attrs}{A boolean indicating if the original lines attributes}
}
\value{
A list containing the following elements:
\itemize{
        \item graph: an igraph object that preserves the original lines
        characteristics
        \item linelist: the dataframe used to build the graph
        \item lines: the original SpatialLinesDataFrame
        \item spvertices: a SpatialPointsDataFrame representing the vertices
        of the graph
        \item digits : the number of digits kept for the coordinates
}
}
\description{
Generate a directed igraph object from a SpatialLinesDataFrame.
}
\examples{
#This is an internal function, no example provided
}
\keyword{internal}
