SpatialPolygonsDataFrame <- function(Sr, data, match.ID = TRUE) {
	if (match.ID) {
		Sr_IDs <- sapply(slot(Sr, "polygons"),
                    function(i) slot(i, "ID"))
		data_IDs <- row.names(data)
		mtch <- match(Sr_IDs, data_IDs)
		if (any(is.na(mtch)))
			stop("row.names of data and Polygons IDs do not match")
		if (length(unique(mtch)) != length(Sr_IDs))
			stop("row.names of data and Polygons IDs do not match")
		data <- data[mtch, , drop = FALSE]
	}
	new("SpatialPolygonsDataFrame", Sr, data=data)
}

setReplaceMethod("polygons", signature(object = "data.frame", value = "SpatialPolygons"),
	function(object, value) SpatialPolygonsDataFrame(value, object))

setMethod("polygons", signature(obj = "SpatialPolygons"),
	function(obj) as(obj, "SpatialPolygons"))

names.SpatialPolygonsDataFrame = function(x) names(x@data)
"names<-.SpatialPolygonsDataFrame" = function(x,value) { names(x@data) = value; x }

as.data.frame.SpatialPolygonsDataFrame = function(x, row.names, optional, ...) x@data

setAs("SpatialPolygonsDataFrame", "data.frame", function(from)
    as.data.frame.SpatialPolygonsDataFrame(from))

row.names.SpatialPolygonsDataFrame <- function(x) {
    sapply(slot(x, "polygons"), slot, "ID")
}

setMethod("[", "SpatialPolygonsDataFrame", function(x, i, j, ... , drop = TRUE) {
    missing.i = missing(i)
    missing.j = missing(j)
    nargs = nargs() # e.g., a[3,] gives 2 for nargs, a[3] gives 1.
    if (missing.i && missing.j) {
        i = TRUE
        j = TRUE
    } else if (missing.j && !missing.i) {
        if (nargs == 2) {
            j = i
            i = TRUE 
        } else {
            j = TRUE
        }
    } else if (missing.i && !missing.j)
        i = TRUE 
    if (is.matrix(i))
        stop("matrix argument not supported in SpatialPolygonsDataFrame selection")
    if (any(is.na(i))) stop("NAs not permitted in row index")
    #SpatialPolygonsDataFrame(as(x, "SpatialPolygons")[i, , drop = FALSE],
    #    data = x@data[i, j, drop = FALSE], match.ID = FALSE)
	x@data = x@data[i, j, ..., drop = FALSE]
	if (is.logical(i)) {
		if (length(i) == 1 && i)
			i = 1:length(x@polygons)
		else
			i <- which(i)
	} else if (is.character(i)) {
                i <- match(i, row.names(x))
        }

	x@polygons = x@polygons[i]
	x@bbox <- .bboxCalcR(x@polygons)
	x@plotOrder = order(match(i, x@plotOrder))
	x
###
### RSB: do something with labelpoints here? How can I check they are present?
### (label points belong to the Polygons objects, not the SpatialPolygons object)
})

setMethod("coordinates", "SpatialPolygonsDataFrame", 
	function(obj) {
            t(sapply(slot(obj, "polygons"), function(i) slot(i, "labpt")))
})

setAs("SpatialPolygonsDataFrame", "SpatialLinesDataFrame", 
	function(from) SpatialLinesDataFrame(as(from, "SpatialLines"),
		from@data, match.ID = FALSE))

dim.SpatialPolygonsDataFrame = function(x) dim(x@data)


