% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node.R
\docType{class}
\name{Node}
\alias{Node}
\title{Node}
\format{Object of \code{\link{R6Class}} with methods for constructing a DAG.}
\usage{
Node
}
\value{
Object of \code{\link{Node}}
}
\description{
This is a base class representing a node in a DAG. Is not intended to be used by a regular user.  Developers only here!
}
\section{Fields}{

\describe{
\item{\code{parents}}{a list of parent nodes}

\item{\code{children}}{a list of child nodes}

\item{\code{name}}{a tag name applied to the node}
}}
\section{Methods}{

\describe{
  \item{\code{new(parents = list(), children = list(), name)}}{creates a new \link{Node} with parent nodes, child nodes, and a name.}
  \item{\code{logDensity()}}{calculate the log probability density/mass function evaluated at the current node value.}
  \item{\code{addChild(node)}}{add \code{node} as a child.  Returns \code{node}.}
  \item{\code{addParent(node)}}{add \code{node} as a parent.  Returns \code{node}.}
  \item{\code{removeParent(name)}}{remove the parent node named \code{name}.  Returns \code{node}.}
  \item{\code{removeChild(name)}}{remove the child node named \code{name}.  Returns \code{node}.}
  }
}
\keyword{DAG}
\keyword{node}

