% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/somregs.R
\name{somregs}
\alias{somregs}
\title{Classify SOM into regions}
\usage{
somregs(x, nregions, ...)
}
\arguments{
\item{x}{A \code{somsp} object.}

\item{nregions}{The maximum number of classifications schemes to be determined starting from 2.}

\item{...}{Other arguments passed to methods from \code{hclust} function which is used to determine the regions.}
}
\value{
A \code{regs} object, which contains:

\itemize{

\item{A summary \code{data.table} which updates the \code{somsp} object with the region ids of all classification schemes
up to \code{nregions}. Each different classification scheme is stored as an individual region, e.g., \code{regions.2},
\code{regions.3}, etc.
to their corresponding winning unit, the number of points of each node, as well as the median
latitude and longitude of each node coordinates and their standard deviation.}

\item{The original time series which created the SOM as a \code{data.table}, as in \code{somsp}.}
}
}
\description{
\code{somregs} applies hierarchical cluster analysis to the Self-Organizing Map
to form regions with homogeneous characteristics (classification scheme).
}
\details{
\code{nregions} must be at least two, i.e., a classification scheme with two regions, and smaller than
the number of SOM nodes. In the latter case, each SOM node corresponds to a region.
The resulting \code{regs} object can be plotted by \code{plot} and \code{plot_ts}.
If \code{plot} is used, three additional arguments are needed; a set with the classification schemes
that will be ploted, number of rows and number of columns of the plotted panels.
\code{plot_ts} plots all the time series of a given classification scheme.
}
\examples{
dummy <- owda[Time <= 1600] #toy example
inp_som <- sominp(dummy)
my_som <- somspa(inp_som, rlen = 100, grid = somgrid(4, 4, "hexagonal"))
my_regions <- somregs(my_som, nregions = 9) 
plot(my_regions, regions = c(2, 4, 6, 8), nrow = 2, ncol = 2) 
plot_ts(my_regions, n = 4)
\donttest{
inp_som <- sominp(owda)
my_som <- somspa(inp_som)
my_regions <- somregs(my_som, nregions = 15) 
plot(my_regions, regions = c(2, 5, 9, 13), nrow = 2, ncol = 2) 
plot_ts(my_regions, n = 9)}

}
\seealso{
\code{\link{somsp}}

\code{\link{somspa}}
}
