% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_SDA_cosurfmorph.R
\name{get_SDA_cosurfmorph}
\alias{get_SDA_cosurfmorph}
\title{Get Geomorphic/Surface Morphometry Data from Soil Data Access}
\usage{
get_SDA_cosurfmorph(
  table = c("cosurfmorphgc", "cosurfmorphhpp", "cosurfmorphss", "cosurfmorphmr"),
  by = "compname",
  areasymbols = NULL,
  mukeys = NULL,
  WHERE = NULL,
  miscellaneous_areas = FALSE,
  db = c("SSURGO", "STATSGO"),
  dsn = NULL,
  query_string = FALSE
)
}
\arguments{
\item{table}{Target table to summarize. Default: \code{"cosurfmorphgc"} (3D Geomorphic Component). Alternate choices include \code{cosurfmorphhpp} (2D Hillslope Position), \code{cosurfmorphss} (Surface Shape), and  \code{cosurfmorphmr} (Microrelief).}

\item{by}{Grouping variable. Default: \code{"compname"}}

\item{areasymbols}{A vector of soil survey area symbols (e.g. \code{'CA067'})}

\item{mukeys}{A vector of map unit keys (e.g. \code{466627})}

\item{WHERE}{WHERE clause added to SQL query. For example: \code{areasymbol = 'CA067'}}

\item{miscellaneous_areas}{Include miscellaneous areas  (non-soil components) in results? Default: \code{FALSE}.}

\item{db}{Either \code{'SSURGO'} (default) or \code{'STATSGO'}. If \code{'SSURGO'} is specified \code{areasymbol = 'US'} records are excluded. If \code{'STATSGO'} only \code{areasymbol = 'US'} records are included.}

\item{dsn}{Path to local SSURGO database SQLite database. Default \code{NULL} uses Soil Data Access.}

\item{query_string}{Return query instead of sending to Soil Data Access / local database. Default: \code{FALSE}.}
}
\value{
a \code{data.frame} containing the grouping variable (\code{by}) and tabular summaries of counts and proportions of geomorphic records.
}
\description{
Get Geomorphic/Surface Morphometry Data from Soil Data Access or a local SSURGO data source and summarize by counts and proportions ("probabilities").
}
\details{
Default \code{table="cosurfmorphgc"} summarizes columns \code{geomposmntn}, \code{geomposhill}, \code{geomposflats}, and \code{geompostrce}.
\code{table="cosurfmorphhpp"} summarizes \code{"hillslopeprof"},  \code{table="cosurfmorphss"} summarizes \code{shapeacross} and \code{shapedown}, and \code{table="cosurfmorphmr"} summarizes \code{geomicrorelief}.

Queries are a generalization of now-deprecated functions from sharpshootR package by Dylan Beaudette: \code{geomPosMountainProbability()}, \code{geomPosHillProbability()}, \code{surfaceShapeProbability()}, \code{hillslopeProbability()}

Similar summaries of SSURGO component surface morphometry data by series name can be found in \code{fetchOSD(, extended=TRUE)} or downloaded from \url{https://github.com/ncss-tech/SoilWeb-data}
Full component data including surface morphometry summaries at the "site" level can be obtained with \code{fetchSDA()}.
}
\examples{
\dontrun{
 # Summarize by 3D geomorphic components by component name (default `by='compname'`)
 get_SDA_cosurfmorph(WHERE = "areasymbol = 'CA630'")

 # Whole Soil Survey Area summary (using `by = 'areasymbol'`)
 get_SDA_cosurfmorph(by = 'areasymbol', WHERE = "areasymbol = 'CA630'")

 # 2D Hillslope Position summary(using `table = 'cosurfmorphhpp'`)
 get_SDA_cosurfmorph('cosurfmorphhpp', WHERE = "areasymbol = 'CA630'")

 # Surface Shape summary (using `table = 'cosurfmorphss'`)
 get_SDA_cosurfmorph('cosurfmorphss', WHERE = "areasymbol = 'CA630'")

 # Microrelief summary (using `table = 'cosurfmorphmr'`)
 get_SDA_cosurfmorph('cosurfmorphmr', WHERE = "areasymbol = 'CA630'")
}
}
\seealso{
\code{fetchSDA()} \code{get_SDA_pmgroupname()}
}
\author{
Dylan E. Beaudette, Andrew G. Brown
}
