% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_text_notes_from_NASIS_db.R
\name{get_text_notes_from_NASIS_db}
\alias{get_text_notes_from_NASIS_db}
\title{Get text note data from a local NASIS Database}
\usage{
get_text_notes_from_NASIS_db(SS = TRUE, fixLineEndings = TRUE, dsn = NULL)
}
\arguments{
\item{SS}{get data from the currently loaded Selected Set in NASIS or from
the entire local database (default: \code{TRUE})}

\item{fixLineEndings}{convert line endings from \verb{\\r\\n} to \verb{\\n}}

\item{dsn}{Optional: path to local SQLite database containing NASIS
table structure; default: \code{NULL}}
}
\value{
A \code{list} with the results.
}
\description{
Get text note data from a local NASIS Database
}
\examples{

\donttest{
if(local_NASIS_defined()) {
 # query text note data
 t <- try(get_text_notes_from_NASIS_db())

 # show contents text note data, includes: siteobs, site, pedon, horizon level text notes data.
 str(t)

 # view text categories for site text notes
 if(!inherits(t, 'try-error')) {
  table(t$site_text$textcat)
 }
}
}

}
\seealso{
\code{\link{get_hz_data_from_pedon_db}},
\code{\link{get_site_data_from_pedon_db}}
}
\author{
Dylan E. Beaudette and Jay M. Skovlin
}
\keyword{manip}
