% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_NASIS_table_name_by_purpose.R
\name{get_NASIS_table_name_by_purpose}
\alias{get_NASIS_table_name_by_purpose}
\title{Get NASIS 7 Physical Table Names}
\usage{
get_NASIS_table_name_by_purpose(
  purpose = c("metadata", "lookup", "site", "pedon", "transect", "component",
    "vegetation", "project", "techsoilservice", "area", "soilseries", "legend",
    "mapunit", "datamapunit"),
  SS = FALSE
)
}
\arguments{
\item{purpose}{character. One or more of: "metadata", "lookup", "site", "pedon", "transect", "datamapunit", "component", "vegetation"}

\item{SS}{append "_View_1" on appropriate tables? Default: FALSE}
}
\value{
character vector of table names
}
\description{
Method generalizing concepts of NASIS 7 data model to group tables by "purpose." Most of our more complex queries rely on tables from one or more purposes, so individual higher-level functions might call a function like this to identify the relevant tables from a data source.
}
\examples{
\dontrun{
# get the "site" table names
get_NASIS_table_name_by_purpose("site")

# get the pedon table names
get_NASIS_table_name_by_purpose("pedon", SS = TRUE)

# metadata and lookup not affected by SS argument, but site and pedon are
get_NASIS_table_name_by_purpose(c("metadata", "lookup",
                                   "site", "pedon"), SS = TRUE)
}

}
\seealso{
createStaticNASIS
}
