% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seriesExtent.R
\name{seriesExtent}
\alias{seriesExtent}
\title{Retrieve Soil Series Extent Maps from SoilWeb}
\usage{
seriesExtent(s, type = c("vector", "raster"), timeout = 60)
}
\arguments{
\item{s}{a soil series name, case-insensitive}

\item{type}{series extent representation, \code{vector} results in a \code{SpatialPolygonsDataFrame} object and \code{raster} results in a \code{raster} object}

\item{timeout}{time that we are willing to wait for a response, in seconds}
}
\description{
This function downloads a generalized representations of a soil series extent from SoilWeb, derived from the current SSURGO snapshot. Data can be returned as vector outlines (\code{SpatialPolygonsDataFrame} object) or gridded representation of area proportion falling within 800m cells (\code{raster} object). Gridded series extent data are only available in CONUS. Vector representations are returned with a GCS/WGS84 coordinate reference system and raster representations are returned with an Albers Equal Area / NAD83 coordinate reference system (EPSG 5070).
}
\note{
This function requires the \code{rgdal} package.
}
\examples{
  
\donttest{
if(requireNamespace("curl") &
   curl::has_internet()) {
  
  # required packages
  library(sp)
  library(raster)
  library(rgdal)
  
  # specify a soil series name
  s <- 'magnor'
  
  # return as SpatialPolygonsDataFrame
  x <- seriesExtent(s, type = 'vector')
  # return as raster
  y <- seriesExtent(s, type = 'raster')
  
  # note that CRS are different
  proj4string(x)
  projection(y)
  
  # transform vector representation to CRS of raster
  x <- spTransform(x, CRS(projection(y)))
  
  # graphical comparison
  par(mar = c(1, 1 , 1, 3))
  plot(y, axes = FALSE)
  plot(x, add = TRUE)
  
  
}
}

}
\references{
\url{https://casoilresource.lawr.ucdavis.edu/see/}
}
\author{
D.E. Beaudette
}
