\name{ken.sto}
\Rdversion{1.1}
\alias{ken.sto}
\alias{plot.ken.sto}
\title{Sample selection based on the Kennard-Stone algorithm}
\description{
The function chooses based on Euclidean distance measure most representative samples. One can (i) select a number or a percentage of a sample set or (ii) divide a sample set into calibration and representative validation set.
}
\usage{
ken.sto(inp, per = "T", per.n = 0.3, num, va = "F", sav = "T", path = "", out = "Sel")

\method{plot}{ken.sto}(x,...)
}
\arguments{
  \item{inp}{a numerical matrix or data.frame containing the input spectra}
  \item{per}{a logical value indicating whether the selected samples should be a percentage (given in \code{per.n}) or a set number (given in \code{num}) of \code{inp}. The default \code{"T"} takes a percentage.}
  \item{per.n}{a numerical value between 0 and 1.}
  \item{num}{a numerical value between 1 and the sample number minus 1.}
  \item{va}{a logical value indicating whether to select samples out of \code{inp} or to divide them into a calibration and validation set.}    \item{sav}{a logical value indicating whether the function output shall be saved.}
  \item{path}{a character giving the path name where the function output shall be saved.}
  \item{out}{a character giving the function output name, in case \code{sav} is \code{"T"}.}
  \item{x}{an object of class \code{"ken.sto"}.}
  \item{...}{additional arguments.}
}
\details{
Sample selection is done following and adapted procedure from Kennard & Stone (1969). It is a stepwise procedure by maximizing the Euclidean distance based on the important number of principal components to the objects already chosen. The number of important principal components is selected so that the increase in cumulative explained variance within the next three components is lower than 4 percent. The starting samples are the two extreme samples (most negative and positive ones) of the important principal components. 

\code{per.n} having a value of 0.4 while \code{va} equal to \code{"F"} chooses 40 percent of the sample set. When \code{va} is equal to \code{"T"} the validation set comprises 40 percent of the sample set.

A graph is given back showing the selected samples in the principal component space (only the important PC's). This is the same graphic generated by \code{\link{plot.ken.sto}}.
}
\value{
\code{ken.sto} returns a list with class \code{"ken.sto"} containing the following components: 
  \item{Calibration and validation set}{the logical object \code{va}.}
  \item{Number important PC}{integer giving the number of chosen important components - important for choosing the starting samples.}
  \item{PC space important PC}{score value matrix of important principal components.}
  \item{Chosen samples names}{chosen sample names when \code{va} equal to \code{"F"}.}
  \item{Chosen row number}{chosen row numbers when \code{va} equal to \code{"F"}.}
  \item{Chosen calibration sample names}{chosen calibration sample names when \code{va} equal to \code{"T"}.}
  \item{Chosen calibration row number}{chosen calibration row numbers when \code{va} equal to \code{"T"}.}
  \item{Chosen validation sample names}{chosen validation sample names when \code{va} equal to \code{"T"}.}
  \item{Chosen validation  row number}{chosen validation row numbers when \code{va} equal to \code{"T"}.}}
\references{
Kennard, R. W. and Stone, L. A. (1969) \emph{Computer aided design of experiments.} Technometrics 11(1), 137-148.
}
\author{Thomas Terhoeven-Urselmans}
